/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tools.apt.AbstractAnnotationProcessor;
import org.apache.camel.tools.apt.Func1;
import org.apache.camel.tools.apt.JsonSchemaHelper;
import org.apache.camel.tools.apt.Strings;

@SupportedAnnotationTypes(value={"javax.xml.bind.annotation.*", "org.apache.camel.spi.Label"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class EipAnnotationProcessor
extends AbstractAnnotationProcessor {
    private static final String ONE_OF_TYPE_NAME = "org.apache.camel.model.ExpressionSubElementDefinition";
    private static final String ONE_OF_LANGUAGES = "org.apache.camel.model.language.ExpressionDefinition";
    private static final String[] ONE_OF_INPUTS = new String[]{"org.apache.camel.model.ProcessorDefinition", "org.apache.camel.model.VerbDefinition"};
    private static final String[] ONE_OF_OUTPUTS = new String[]{"org.apache.camel.model.ProcessorDefinition", "org.apache.camel.model.NoOutputDefinition", "org.apache.camel.model.OutputDefinition", "org.apache.camel.model.ExpressionNode", "org.apache.camel.model.NoOutputExpressionNode", "org.apache.camel.model.SendDefinition", "org.apache.camel.model.InterceptDefinition", "org.apache.camel.model.WhenDefinition"};
    private boolean skipUnwanted = true;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(XmlRootElement.class);
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            this.processModelClass(roundEnv, (TypeElement)element);
        }
        return true;
    }

    protected void processModelClass(final RoundEnvironment roundEnv, final TypeElement classElement) {
        String name;
        final String javaTypeName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
        String packageName = javaTypeName.substring(0, javaTypeName.lastIndexOf("."));
        if (!javaTypeName.startsWith("org.apache.camel.model")) {
            return;
        }
        if (classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        if (this.skipUnwanted && classElement.getQualifiedName().toString().equals(ONE_OF_TYPE_NAME)) {
            return;
        }
        final XmlRootElement rootElement = classElement.getAnnotation(XmlRootElement.class);
        if (rootElement == null) {
            return;
        }
        String aName = rootElement.name();
        if (Strings.isNullOrEmpty(aName) || "##default".equals(aName)) {
            XmlType typeElement = classElement.getAnnotation(XmlType.class);
            aName = typeElement.name();
        }
        String fileName = Strings.isNullOrEmpty(name = aName) || "##default".equals(name) ? classElement.getSimpleName().toString() + ".json" : name + ".json";
        Func1<PrintWriter, Void> handler = new Func1<PrintWriter, Void>(){

            @Override
            public Void call(PrintWriter writer) {
                EipAnnotationProcessor.this.writeJSonSchemeDocumentation(writer, roundEnv, classElement, rootElement, javaTypeName, name);
                return null;
            }
        };
        this.processFile(packageName, fileName, handler);
    }

    protected void writeJSonSchemeDocumentation(PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, XmlRootElement rootElement, String javaTypeName, String name) {
        EipModel eipModel = this.findEipModelProperties(roundEnv, classElement, javaTypeName, name);
        TreeSet<EipOption> eipOptions = new TreeSet<EipOption>(new EipOptionComparator(eipModel));
        this.findClassProperties(writer, roundEnv, eipOptions, classElement, classElement, "");
        eipModel.setInput(this.hasInput(roundEnv, classElement));
        eipModel.setOutput(this.hasOutput(eipModel, eipOptions));
        String json = this.createParameterJsonSchema(eipModel, eipOptions);
        writer.println(json);
    }

    public String createParameterJsonSchema(EipModel eipModel, Set<EipOption> options) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"model\": {");
        buffer.append("\n    \"kind\": \"").append("model").append("\",");
        buffer.append("\n    \"name\": \"").append(eipModel.getName()).append("\",");
        buffer.append("\n    \"title\": \"").append(EipAnnotationProcessor.asTitle(eipModel.getName())).append("\",");
        buffer.append("\n    \"description\": \"").append(Strings.safeNull(eipModel.getDescription())).append("\",");
        buffer.append("\n    \"javaType\": \"").append(eipModel.getJavaType()).append("\",");
        buffer.append("\n    \"label\": \"").append(Strings.safeNull(eipModel.getLabel())).append("\",");
        buffer.append("\n    \"input\": \"").append(eipModel.getInput()).append("\",");
        buffer.append("\n    \"output\": \"").append(eipModel.getOutput()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        boolean first = true;
        for (EipOption entry : options) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc = entry.getDocumentation();
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            buffer.append(JsonSchemaHelper.toJson(entry.getName(), entry.getKind(), entry.isRequired(), entry.getType(), entry.getDefaultValue(), doc, entry.isDeprecated(), null, entry.isEnumType(), entry.getEnums(), entry.isOneOf(), entry.getOneOfTypes()));
        }
        buffer.append("\n  }");
        buffer.append("\n}\n");
        return buffer.toString();
    }

    protected EipModel findEipModelProperties(RoundEnvironment roundEnv, TypeElement classElement, String javaTypeName, String name) {
        EipModel model = new EipModel();
        model.setJavaType(javaTypeName);
        model.setName(name);
        Metadata metadata = classElement.getAnnotation(Metadata.class);
        if (metadata != null && !Strings.isNullOrEmpty(metadata.label())) {
            model.setLabel(metadata.label());
        }
        if (model.getJavaType() != null) {
            String doc;
            Elements elementUtils = this.processingEnv.getElementUtils();
            TypeElement typeElement = this.findTypeElement(roundEnv, model.getJavaType());
            if (typeElement != null && (doc = elementUtils.getDocComment(typeElement)) != null && !Strings.isNullOrEmpty(doc = JsonSchemaHelper.sanitizeDescription(doc, true))) {
                model.setDescription(doc);
            }
        }
        return model;
    }

    protected void findClassProperties(PrintWriter writer, RoundEnvironment roundEnv, Set<EipOption> eipOptions, TypeElement originalClassType, TypeElement classElement, String prefix) {
        while (true) {
            List<VariableElement> fieldElements = ElementFilter.fieldsIn(classElement.getEnclosedElements());
            for (VariableElement fieldElement : fieldElements) {
                XmlElementRef elementRef;
                XmlElement element;
                XmlElements elements;
                boolean skip;
                String fieldName = fieldElement.getSimpleName().toString();
                XmlAttribute attribute = fieldElement.getAnnotation(XmlAttribute.class);
                if (attribute != null && (skip = this.processAttribute(roundEnv, originalClassType, classElement, fieldElement, fieldName, attribute, eipOptions, prefix))) continue;
                XmlValue value = fieldElement.getAnnotation(XmlValue.class);
                if (value != null) {
                    this.processValue(roundEnv, originalClassType, classElement, fieldElement, fieldName, value, eipOptions, prefix);
                }
                if ((elements = fieldElement.getAnnotation(XmlElements.class)) != null) {
                    this.processElements(roundEnv, classElement, elements, fieldElement, eipOptions, prefix);
                }
                if ((element = fieldElement.getAnnotation(XmlElement.class)) != null) {
                    this.processElement(roundEnv, classElement, element, fieldElement, eipOptions, prefix);
                }
                if ((elementRef = fieldElement.getAnnotation(XmlElementRef.class)) == null) continue;
                this.processOutputs(roundEnv, originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processRefExpression(roundEnv, originalClassType, classElement, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processRefWhenClauses(roundEnv, originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
            }
            if ("OptionalIdentifiedDefinition".equals(classElement.getSimpleName().toString())) {
                this.processIdentified(roundEnv, originalClassType, classElement, eipOptions, prefix);
            } else if ("RouteDefinition".equals(classElement.getSimpleName().toString())) {
                this.processRoute(roundEnv, originalClassType, classElement, eipOptions, prefix);
            }
            TypeElement baseTypeElement = null;
            TypeMirror superclass = classElement.getSuperclass();
            if (superclass != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = this.findTypeElement(roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    private boolean processAttribute(RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, VariableElement fieldElement, String fieldName, XmlAttribute attribute, Set<EipOption> eipOptions, String prefix) {
        boolean isEnum;
        boolean loadBalancer;
        Elements elementUtils = this.processingEnv.getElementUtils();
        String name = attribute.name();
        if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
            name = fieldName;
        }
        if (this.skipUnwanted && !(loadBalancer = "LoadBalanceDefinition".equals(originalClassType.getSimpleName().toString())) && "inheritErrorHandler".equals(name)) {
            return true;
        }
        name = prefix + name;
        TypeMirror fieldType = fieldElement.asType();
        String fieldTypeName = fieldType.toString();
        TypeElement fieldTypeElement = this.findTypeElement(roundEnv, fieldTypeName);
        String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
        String docComment = this.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
        boolean required = attribute.required();
        required = this.findRequired(fieldElement, required);
        TreeSet<String> enums = new TreeSet<String>();
        boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
        if (isEnum) {
            TypeElement enumClass = this.findTypeElement(roundEnv, fieldTypeElement.asType().toString());
            List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
            for (VariableElement var : fields) {
                if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                String val = var.toString();
                enums.add(val);
            }
        }
        boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
        EipOption ep = new EipOption(name, "attribute", fieldTypeName, required, defaultValue, docComment, deprecated, isEnum, enums, false, null);
        eipOptions.add(ep);
        return false;
    }

    private void processValue(RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, VariableElement fieldElement, String fieldName, XmlValue value, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        String name = fieldName;
        name = prefix + name;
        TypeMirror fieldType = fieldElement.asType();
        String fieldTypeName = fieldType.toString();
        String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
        String docComment = this.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
        boolean required = true;
        required = this.findRequired(fieldElement, required);
        boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
        EipOption ep = new EipOption(name, "value", fieldTypeName, required, defaultValue, docComment, deprecated, false, null, false, null);
        eipOptions.add(ep);
    }

    private void processElement(RoundEnvironment roundEnv, TypeElement classElement, XmlElement element, VariableElement fieldElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        String fieldName = fieldElement.getSimpleName().toString();
        if (element != null) {
            boolean isEnum;
            String kind = "element";
            String name = element.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            TypeElement fieldTypeElement = this.findTypeElement(roundEnv, fieldTypeName);
            String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
            String docComment = this.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
            boolean required = element.required();
            required = this.findRequired(fieldElement, required);
            LinkedHashSet<String> enums = new LinkedHashSet<String>();
            boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
            if (isEnum) {
                TypeElement enumClass = this.findTypeElement(roundEnv, fieldTypeElement.asType().toString());
                List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                for (VariableElement var : fields) {
                    if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    String val = var.toString();
                    enums.add(val);
                }
            }
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            boolean isOneOf = ONE_OF_TYPE_NAME.equals(fieldTypeName);
            if (isOneOf) {
                kind = "expression";
                fieldTypeName = ONE_OF_LANGUAGES;
                TypeElement languages = this.findTypeElement(roundEnv, ONE_OF_LANGUAGES);
                String superClassName = Strings.canonicalClassName(languages.toString());
                LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
                this.findTypeElementChildren(roundEnv, children, superClassName);
                for (TypeElement child : children) {
                    String childName;
                    XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                    if (rootElement == null || (childName = rootElement.name()) == null) continue;
                    oneOfTypes.add(childName);
                }
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            EipOption ep = new EipOption(name, kind, fieldTypeName, required, defaultValue, docComment, deprecated, isEnum, enums, isOneOf, oneOfTypes);
            eipOptions.add(ep);
        }
    }

    private void processElements(RoundEnvironment roundEnv, TypeElement classElement, XmlElements elements, VariableElement fieldElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        String fieldName = fieldElement.getSimpleName().toString();
        if (elements != null) {
            String kind = "element";
            String name = fieldName;
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
            String docComment = this.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, true);
            boolean required = true;
            required = this.findRequired(fieldElement, required);
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            for (XmlElement element : elements.value()) {
                String child = element.name();
                oneOfTypes.add(child);
            }
            EipOption ep = new EipOption(name, kind, fieldTypeName, required, defaultValue, docComment, false, false, null, true, oneOfTypes);
            eipOptions.add(ep);
        }
    }

    private void processRoute(RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        String docComment = this.findJavaDoc(elementUtils, null, "group", null, classElement, true);
        EipOption ep = new EipOption("group", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "streamCache", null, classElement, true);
        ep = new EipOption("streamCache", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "trace", null, classElement, true);
        ep = new EipOption("trace", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "messageHistory", null, classElement, true);
        ep = new EipOption("messageHistory", "attribute", "java.lang.String", false, "true", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "handleFault", null, classElement, true);
        ep = new EipOption("handleFault", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "delayer", null, classElement, true);
        ep = new EipOption("delayer", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "autoStartup", null, classElement, true);
        ep = new EipOption("autoStartup", "attribute", "java.lang.String", false, "true", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "startupOrder", null, classElement, true);
        ep = new EipOption("startupOrder", "attribute", "java.lang.Integer", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "errorHandlerRef", null, classElement, true);
        ep = new EipOption("errorHandlerRef", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "routePolicyRef", null, classElement, true);
        ep = new EipOption("routePolicyRef", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        LinkedHashSet<String> enums = new LinkedHashSet<String>();
        enums.add("Default");
        enums.add("Defer");
        docComment = this.findJavaDoc(elementUtils, null, "shutdownRoute", "Default", classElement, true);
        ep = new EipOption("shutdownRoute", "attribute", "org.apache.camel.ShutdownRoute", false, "", docComment, false, true, enums, false, null);
        eipOptions.add(ep);
        enums = new LinkedHashSet();
        enums.add("CompleteCurrentTaskOnly");
        enums.add("CompleteAllTasks");
        docComment = this.findJavaDoc(elementUtils, null, "shutdownRunningTask", "CompleteCurrentTaskOnly", classElement, true);
        ep = new EipOption("shutdownRunningTask", "attribute", "org.apache.camel.ShutdownRunningTask", false, "", docComment, false, true, enums, false, null);
        eipOptions.add(ep);
        TreeSet<String> oneOfTypes = new TreeSet<String>();
        oneOfTypes.add("from");
        docComment = this.findJavaDoc(elementUtils, null, "inputs", null, classElement, true);
        ep = new EipOption("inputs", "element", "java.util.List<org.apache.camel.model.FromDefinition>", true, "", docComment, false, false, null, true, oneOfTypes);
        eipOptions.add(ep);
        oneOfTypes = new TreeSet();
        LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
        for (String superclass : ONE_OF_OUTPUTS) {
            this.findTypeElementChildren(roundEnv, children, superclass);
        }
        for (TypeElement child : children) {
            String childName;
            XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
            if (rootElement == null || (childName = rootElement.name()) == null) continue;
            oneOfTypes.add(childName);
        }
        oneOfTypes.remove("route");
        docComment = this.findJavaDoc(elementUtils, null, "outputs", null, classElement, true);
        ep = new EipOption("outputs", "element", "java.util.List<org.apache.camel.model.ProcessorDefinition<?>>", true, "", docComment, false, false, null, true, oneOfTypes);
        eipOptions.add(ep);
    }

    private void processIdentified(RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        String docComment = this.findJavaDoc(elementUtils, null, "id", null, classElement, true);
        EipOption ep = new EipOption("id", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(elementUtils, null, "description", null, classElement, true);
        ep = new EipOption("description", "element", "org.apache.camel.model.DescriptionDefinition", false, "", docComment, false, false, null, false, null);
        eipOptions.add(ep);
        if (!this.skipUnwanted) {
            docComment = this.findJavaDoc(elementUtils, null, "customId", null, classElement, true);
            ep = new EipOption("customId", "attribute", "java.lang.String", false, "", docComment, false, false, null, false, null);
            eipOptions.add(ep);
        }
    }

    private void processOutputs(RoundEnvironment roundEnv, TypeElement originalClassType, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        if ("outputs".equals(fieldName) && this.supportOutputs(originalClassType)) {
            String kind = "element";
            String name = elementRef.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
            for (String superclass : ONE_OF_OUTPUTS) {
                this.findTypeElementChildren(roundEnv, children, superclass);
            }
            for (TypeElement child : children) {
                String childName;
                XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                if (rootElement == null || (childName = rootElement.name()) == null) continue;
                oneOfTypes.add(childName);
            }
            oneOfTypes.remove("route");
            EipOption ep = new EipOption(name, kind, fieldTypeName, true, "", "", false, false, null, true, oneOfTypes);
            eipOptions.add(ep);
        }
    }

    private void processRefExpression(RoundEnvironment roundEnv, TypeElement originalClassType, TypeElement classElement, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        if ("expression".equals(fieldName)) {
            String kind = "expression";
            String name = elementRef.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            String docComment = this.findJavaDoc(elementUtils, fieldElement, fieldName, name, originalClassType, true);
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            TypeElement languages = this.findTypeElement(roundEnv, ONE_OF_LANGUAGES);
            String superClassName = Strings.canonicalClassName(languages.toString());
            LinkedHashSet<TypeElement> children = new LinkedHashSet<TypeElement>();
            this.findTypeElementChildren(roundEnv, children, superClassName);
            for (TypeElement child : children) {
                String childName;
                XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                if (rootElement == null || (childName = rootElement.name()) == null) continue;
                oneOfTypes.add(childName);
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            EipOption ep = new EipOption(name, kind, fieldTypeName, true, "", docComment, deprecated, false, null, true, oneOfTypes);
            eipOptions.add(ep);
        }
    }

    private void processRefWhenClauses(RoundEnvironment roundEnv, TypeElement originalClassType, XmlElementRef elementRef, VariableElement fieldElement, String fieldName, Set<EipOption> eipOptions, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        if ("whenClauses".equals(fieldName)) {
            String kind = "element";
            String name = elementRef.name();
            if (Strings.isNullOrEmpty(name) || "##default".equals(name)) {
                name = fieldName;
            }
            name = prefix + name;
            TypeMirror fieldType = fieldElement.asType();
            String fieldTypeName = fieldType.toString();
            String docComment = this.findJavaDoc(elementUtils, fieldElement, fieldName, name, originalClassType, true);
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            EipOption ep = new EipOption(name, kind, fieldTypeName, false, "", docComment, deprecated, false, null, false, null);
            eipOptions.add(ep);
        }
    }

    private boolean supportOutputs(TypeElement classElement) {
        String superclass = Strings.canonicalClassName(classElement.getSuperclass().toString());
        return !"org.apache.camel.model.NoOutputExpressionNode".equals(superclass);
    }

    private String findDefaultValue(VariableElement fieldElement, String fieldTypeName) {
        String defaultValue = null;
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null && !Strings.isNullOrEmpty(metadata.defaultValue())) {
            defaultValue = metadata.defaultValue();
        }
        if (defaultValue == null && ("boolean".equals(fieldTypeName) || "java.lang.Boolean".equals(fieldTypeName))) {
            defaultValue = "false";
        }
        return defaultValue;
    }

    private boolean findRequired(VariableElement fieldElement, boolean defaultValue) {
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null && !Strings.isNullOrEmpty(metadata.required())) {
            defaultValue = "true".equals(metadata.required());
        }
        return defaultValue;
    }

    private static String asTitle(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            boolean first;
            boolean upper = Character.isUpperCase(c);
            boolean bl = first = sb.length() == 0;
            if (first) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (upper) {
                sb.append(' ');
                sb.append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString().trim();
    }

    private boolean hasInput(RoundEnvironment roundEnv, TypeElement classElement) {
        for (String name : ONE_OF_INPUTS) {
            if (!this.hasSuperClass(roundEnv, classElement, name)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOutput(EipModel model, Set<EipOption> options) {
        if ("from".equals(model.getName()) || "rest".equals(model.getName())) {
            return true;
        }
        for (EipOption option : options) {
            if (!"outputs".equals(option.getName())) continue;
            return true;
        }
        return false;
    }

    private static final class EipOptionComparator
    implements Comparator<EipOption> {
        private final EipModel model;

        private EipOptionComparator(EipModel model) {
            this.model = model;
        }

        @Override
        public int compare(EipOption o1, EipOption o2) {
            int weigth2;
            int weigth = this.weigth(o1);
            if (weigth == (weigth2 = this.weigth(o2))) {
                return 1;
            }
            return weigth2 - weigth;
        }

        private int weigth(EipOption o) {
            String name = o.getName();
            if ("description".equals(name)) {
                return -10;
            }
            if ("id".equals(name)) {
                return -9;
            }
            if ("pattern".equals(name) && "to".equals(this.model.getName())) {
                return -8;
            }
            return 0;
        }
    }

    private static final class EipOption {
        private String name;
        private String kind;
        private String type;
        private boolean required;
        private String defaultValue;
        private String documentation;
        private boolean deprecated;
        private boolean enumType;
        private Set<String> enums;
        private boolean oneOf;
        private Set<String> oneOfTypes;

        private EipOption(String name, String kind, String type, boolean required, String defaultValue, String documentation, boolean deprecated, boolean enumType, Set<String> enums, boolean oneOf, Set<String> oneOfTypes) {
            this.name = name;
            this.kind = kind;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.documentation = documentation;
            this.deprecated = deprecated;
            this.enumType = enumType;
            this.enums = enums;
            this.oneOf = oneOf;
            this.oneOfTypes = oneOfTypes;
        }

        public String getName() {
            return this.name;
        }

        public String getKind() {
            return this.kind;
        }

        public String getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public boolean isEnumType() {
            return this.enumType;
        }

        public Set<String> getEnums() {
            return this.enums;
        }

        public boolean isOneOf() {
            return this.oneOf;
        }

        public Set<String> getOneOfTypes() {
            return this.oneOfTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EipOption that = (EipOption)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class EipModel {
        private String name;
        private String javaType;
        private String label;
        private String description;
        private boolean input;
        private boolean output;

        private EipModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isInput() {
            return this.input;
        }

        public void setInput(boolean input) {
            this.input = input;
        }

        public String getInput() {
            return this.input ? "true" : "false";
        }

        public boolean isOutput() {
            return this.output;
        }

        public void setOutput(boolean output) {
            this.output = output;
        }

        public String getOutput() {
            return this.output ? "true" : "false";
        }
    }
}

