/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.apache.camel.tools.apt.CollectionStringBuffer;
import org.apache.camel.tools.apt.Strings;

final class JsonSchemaHelper {
    private static final String VALID_CHARS = ".-='/\\!&():;";

    private JsonSchemaHelper() {
    }

    public static String toJson(String name, String kind, Boolean required, String type, String defaultValue, String description, Boolean deprecated, String label, boolean enumType, Set<String> enums, boolean oneOfType, Set<String> oneOffTypes) {
        String text;
        String typeName = JsonSchemaHelper.getType(type, enumType);
        StringBuilder sb = new StringBuilder();
        sb.append(Strings.doubleQuote(name));
        sb.append(": { \"kind\": ");
        sb.append(Strings.doubleQuote(kind));
        if (!Strings.isNullOrEmpty(label)) {
            sb.append(", \"label\": ");
            sb.append(Strings.doubleQuote(label));
        }
        if (required != null) {
            sb.append(", \"required\": ");
            sb.append(Strings.doubleQuote(required.toString()));
        }
        sb.append(", \"type\": ");
        if ("enum".equals(typeName)) {
            sb.append(Strings.doubleQuote("string"));
            sb.append(", \"javaType\": \"" + type + "\"");
            CollectionStringBuffer enumValues = new CollectionStringBuffer();
            for (String value : enums) {
                enumValues.append(Strings.doubleQuote(value.toString()));
            }
            sb.append(", \"enum\": [ ");
            sb.append(enumValues.toString());
            sb.append(" ]");
        } else if (oneOfType) {
            sb.append(Strings.doubleQuote(typeName));
            sb.append(", \"javaType\": \"" + type + "\"");
            CollectionStringBuffer oneOfValues = new CollectionStringBuffer();
            for (String value : oneOffTypes) {
                oneOfValues.append(Strings.doubleQuote(value.toString()));
            }
            sb.append(", \"oneOf\": [ ");
            sb.append(oneOfValues.toString());
            sb.append(" ]");
        } else if ("array".equals(typeName)) {
            sb.append(Strings.doubleQuote("array"));
            sb.append(", \"javaType\": \"" + type + "\"");
        } else {
            sb.append(Strings.doubleQuote(typeName));
            sb.append(", \"javaType\": \"" + type + "\"");
        }
        if (deprecated != null) {
            sb.append(", \"deprecated\": ");
            sb.append(Strings.doubleQuote(deprecated.toString()));
        }
        if (!Strings.isNullOrEmpty(defaultValue)) {
            sb.append(", \"defaultValue\": ");
            text = JsonSchemaHelper.safeDefaultValue(defaultValue);
            sb.append(Strings.doubleQuote(text));
        }
        if (!Strings.isNullOrEmpty(description)) {
            sb.append(", \"description\": ");
            text = JsonSchemaHelper.sanitizeDescription(description, false);
            sb.append(Strings.doubleQuote(text));
        }
        sb.append(" }");
        return sb.toString();
    }

    public static String getType(String type, boolean enumType) {
        if (enumType) {
            return "enum";
        }
        if (type == null) {
            return "object";
        }
        if (type.equals(URI.class.getName()) || type.equals(URL.class.getName())) {
            return "string";
        }
        if (type.startsWith("java.lang.Class")) {
            return "string";
        }
        if (type.startsWith("java.util.List") || type.startsWith("java.util.Collection")) {
            return "array";
        }
        String primitive = JsonSchemaHelper.getPrimitiveType(type);
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return "boolean";
        }
        if ("boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return "integer";
        }
        if ("int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return "integer";
        }
        if ("long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return "integer";
        }
        if ("short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return "integer";
        }
        if ("byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return "number";
        }
        if ("float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return "number";
        }
        if ("double".equals(name)) {
            return "number";
        }
        return null;
    }

    public static String sanitizeDescription(String javadoc, boolean summary) {
        if (Strings.isNullOrEmpty(javadoc)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] lines = javadoc.split("\n");
        boolean first = true;
        for (String line : lines) {
            boolean haveText;
            if ((line = line.trim()).startsWith("@param") || line.startsWith("@return") || line.startsWith("@deprecated")) break;
            if (line.startsWith("@")) continue;
            line = line.replaceAll("<.*?>", "");
            line = line.replaceAll("\\{\\@\\w+\\s([\\w.]+)\\}", "$1");
            if (!first) {
                sb.append(' ');
            }
            StringBuilder cb = new StringBuilder();
            for (char c : line.toCharArray()) {
                if (Character.isJavaIdentifierPart(c) || VALID_CHARS.indexOf(c) != -1) {
                    cb.append(c);
                    continue;
                }
                if (!Character.isWhitespace(c)) continue;
                cb.append(' ');
            }
            String s = cb.toString().trim();
            sb.append(s);
            boolean empty = Strings.isNullOrEmpty(s);
            boolean endWithDot = s.endsWith(".");
            boolean bl = haveText = sb.length() > 0;
            if (haveText && summary && (empty || endWithDot)) break;
            first = false;
        }
        String s = sb.toString();
        s = s.replaceAll("\\s+", " ");
        return s.trim();
    }

    private static String safeDefaultValue(String value) {
        if ("\"".equals(value)) {
            return "\\\"";
        }
        if ("\\".equals(value)) {
            return "\\\\";
        }
        return value;
    }
}

