/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

final class Strings {
    private Strings() {
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.length() == 0 || "null".equals(text);
    }

    public static String safeNull(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return "";
        }
        return text;
    }

    public static String getOrElse(String text, String defaultValue) {
        return text != null ? text : defaultValue;
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static String canonicalClassName(String className) {
        int pos = className.indexOf(60);
        if (pos != -1) {
            return className.substring(0, pos);
        }
        return className;
    }

    public static String doubleQuote(String text) {
        return Strings.quote(text, "\"");
    }

    public static String singleQuote(String text) {
        return Strings.quote(text, "'");
    }

    public static String quote(String text, String quote) {
        return quote + text + quote;
    }
}

