/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt.helper;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.tools.apt.helper.CollectionStringBuffer;
import org.apache.camel.tools.apt.helper.Strings;

public final class JsonSchemaHelper {
    private static final String VALID_CHARS = ".-='/\\!&():;";
    private static final Pattern PATTERN = Pattern.compile("\"(.+?)\"|\\[(.+)\\]|(true|false)|(-?\\d+\\.?\\d*)");
    private static final String QUOT = "&quot;";

    private JsonSchemaHelper() {
    }

    public static String toJson(String name, String displayName, String kind, Boolean required, String type, String defaultValue, String description, Boolean deprecated, Boolean secret, String group, String label, boolean enumType, Set<String> enums, boolean oneOfType, Set<String> oneOffTypes, boolean asPredicate, String optionalPrefix, String prefix, boolean multiValue) {
        boolean predicate;
        String text;
        String typeName = JsonSchemaHelper.getType(type, enumType);
        StringBuilder sb = new StringBuilder();
        sb.append(Strings.doubleQuote(name));
        sb.append(": { \"kind\": ");
        sb.append(Strings.doubleQuote(kind));
        if (Strings.isNullOrEmpty(displayName)) {
            displayName = Strings.asTitle(name);
        }
        sb.append(", \"displayName\": ");
        sb.append(Strings.doubleQuote(displayName));
        if (!Strings.isNullOrEmpty(group)) {
            sb.append(", \"group\": ");
            sb.append(Strings.doubleQuote(group));
        }
        if (!Strings.isNullOrEmpty(label)) {
            sb.append(", \"label\": ");
            sb.append(Strings.doubleQuote(label));
        }
        if (required != null) {
            sb.append(", \"required\": ");
            sb.append(required.toString());
        }
        sb.append(", \"type\": ");
        if ("enum".equals(typeName)) {
            String actualType = JsonSchemaHelper.getType(type, false);
            sb.append(Strings.doubleQuote(actualType));
            sb.append(", \"javaType\": \"" + type + "\"");
            CollectionStringBuffer enumValues = new CollectionStringBuffer();
            for (String value : enums) {
                enumValues.append(Strings.doubleQuote(value.toString()));
            }
            sb.append(", \"enum\": [ ");
            sb.append(enumValues.toString());
            sb.append(" ]");
        } else if (oneOfType) {
            sb.append(Strings.doubleQuote(typeName));
            sb.append(", \"javaType\": \"" + type + "\"");
            CollectionStringBuffer oneOfValues = new CollectionStringBuffer();
            for (Object e : oneOffTypes) {
                oneOfValues.append(Strings.doubleQuote(e.toString()));
            }
            sb.append(", \"oneOf\": [ ");
            sb.append(oneOfValues.toString());
            sb.append(" ]");
        } else if ("array".equals(typeName)) {
            sb.append(Strings.doubleQuote("array"));
            sb.append(", \"javaType\": \"" + type + "\"");
        } else {
            sb.append(Strings.doubleQuote(typeName));
            sb.append(", \"javaType\": \"" + type + "\"");
        }
        if (!Strings.isNullOrEmpty(optionalPrefix)) {
            sb.append(", \"optionalPrefix\": ");
            text = JsonSchemaHelper.safeDefaultValue(optionalPrefix);
            sb.append(Strings.doubleQuote(text));
        }
        if (!Strings.isNullOrEmpty(prefix)) {
            sb.append(", \"prefix\": ");
            text = JsonSchemaHelper.safeDefaultValue(prefix);
            sb.append(Strings.doubleQuote(text));
        }
        if (multiValue) {
            sb.append(", \"multiValue\": true");
        }
        if (deprecated != null) {
            sb.append(", \"deprecated\": ");
            sb.append(deprecated.toString());
        }
        if (secret != null) {
            sb.append(", \"secret\": ");
            sb.append(secret.toString());
        }
        if (!Strings.isNullOrEmpty(defaultValue)) {
            sb.append(", \"defaultValue\": ");
            text = JsonSchemaHelper.safeDefaultValue(defaultValue);
            if ("boolean".equals(typeName) || "integer".equals(typeName) || "number".equals(typeName)) {
                sb.append(text);
            } else {
                sb.append(Strings.doubleQuote(text));
            }
        }
        boolean bl = predicate = "expression".equals(kind) || asPredicate;
        if (predicate) {
            sb.append(", \"asPredicate\": ");
            if (asPredicate) {
                sb.append("true");
            } else {
                sb.append("false");
            }
        }
        if (!Strings.isNullOrEmpty(description)) {
            sb.append(", \"description\": ");
            String text2 = JsonSchemaHelper.sanitizeDescription(description, false);
            sb.append(Strings.doubleQuote(text2));
        }
        sb.append(" }");
        return sb.toString();
    }

    public static String getType(String type, boolean enumType) {
        if (enumType) {
            return "enum";
        }
        if (type == null) {
            return "object";
        }
        if (type.equals(URI.class.getName()) || type.equals(URL.class.getName())) {
            return "string";
        }
        if (type.equals(File.class.getName())) {
            return "string";
        }
        if (type.equals(Date.class.getName())) {
            return "string";
        }
        if (type.startsWith("java.lang.Class")) {
            return "string";
        }
        if (type.startsWith("java.util.List") || type.startsWith("java.util.Collection")) {
            return "array";
        }
        String primitive = JsonSchemaHelper.getPrimitiveType(type);
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name) || "char".equals(name)) {
            return "string";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name) || "boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name) || "int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name) || "long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name) || "short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name) || "byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name) || "float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name) || "double".equals(name)) {
            return "number";
        }
        return null;
    }

    public static String sanitizeDescription(String javadoc, boolean summary) {
        if (Strings.isNullOrEmpty(javadoc)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] lines = javadoc.split("\n");
        boolean first = true;
        for (String line : lines) {
            boolean haveText;
            if ((line = line.trim()).startsWith("@param") || line.startsWith("@return") || line.startsWith("@deprecated")) break;
            if (line.startsWith("@")) continue;
            line = line.replaceAll("<.*?>", "");
            line = line.replaceAll("\\{\\@\\w+\\s([\\w.]+)\\}", "$1");
            if (!first) {
                sb.append(' ');
            }
            StringBuilder cb = new StringBuilder();
            for (char c : line.toCharArray()) {
                if (Character.isJavaIdentifierPart(c) || VALID_CHARS.indexOf(c) != -1) {
                    cb.append(c);
                    continue;
                }
                if (!Character.isWhitespace(c)) continue;
                cb.append(' ');
            }
            String s = cb.toString().trim();
            sb.append(s);
            boolean empty = Strings.isNullOrEmpty(s);
            boolean endWithDot = s.endsWith(".");
            boolean bl = haveText = sb.length() > 0;
            if (haveText && summary && (empty || endWithDot)) break;
            first = false;
        }
        String s = sb.toString();
        s = s.replaceAll("\\s+", " ");
        return s.trim();
    }

    public static List<Map<String, String>> parseJsonSchema(String group, String json, boolean parseProperties) {
        String[] lines;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (json == null) {
            return answer;
        }
        boolean found = false;
        for (String line : lines = json.split("\n")) {
            if (!found) {
                String s = line.trim();
                found = s.startsWith("\"" + group + "\":") && s.endsWith("{");
                continue;
            }
            if (line.equals("  },") || line.equals("  }")) break;
            line = line.replaceAll("\"\\\\\"\"", "\"&quot;\"");
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            Matcher matcher = PATTERN.matcher(line);
            String key = parseProperties ? "name" : null;
            while (matcher.find()) {
                if (key == null) {
                    key = matcher.group(1);
                    continue;
                }
                String value = matcher.group(1);
                if (value != null) {
                    value = value.trim();
                    value = value.replaceAll(QUOT, "\"");
                    value = JsonSchemaHelper.decodeJson(value);
                }
                if (value == null && (value = matcher.group(2)) != null) {
                    value = value.replaceAll("\"", "");
                    value = value.replaceAll(", ", ",");
                    value = value.trim();
                }
                if (value == null) {
                    value = matcher.group(3);
                }
                if (value == null) {
                    value = matcher.group(4);
                }
                if (value != null) {
                    row.put(key, value);
                }
                key = null;
            }
            if (row.isEmpty()) continue;
            answer.add(row);
        }
        return answer;
    }

    private static String decodeJson(String value) {
        if ("\\\\".equals(value)) {
            value = "\\";
        }
        return value;
    }

    private static String safeDefaultValue(String value) {
        if ("\"".equals(value)) {
            return "\\\"";
        }
        if ("\\".equals(value)) {
            return "\\\\";
        }
        return value;
    }
}

