/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"org.apache.camel.Converter"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ConverterProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                return false;
            }
            if (this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.impl.converter.CoreStaticTypeConverterLoader") != null) {
                return false;
            }
            if (this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.converter.ObjectConverter") == null) {
                return false;
            }
            Comparator comparator = (o1, o2) -> this.processingEnv.getTypeUtils().isAssignable((TypeMirror)o1, (TypeMirror)o2) ? -1 : (this.processingEnv.getTypeUtils().isAssignable((TypeMirror)o2, (TypeMirror)o1) ? 1 : o1.toString().compareTo(o2.toString()));
            TreeMap<String, Map> converters = new TreeMap<String, Map>();
            TypeElement converterAnnotationType = this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.Converter");
            for (Element element : roundEnv.getElementsAnnotatedWith(converterAnnotationType)) {
                if (element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement ee = (ExecutableElement)element;
                TypeMirror typeMirror = ee.getReturnType();
                TypeMirror from = ee.getParameters().get(0).asType();
                String fromStr = this.toString(from);
                if (!fromStr.endsWith("[]")) {
                    TypeElement e = this.processingEnv.getElementUtils().getTypeElement(fromStr);
                    if (e != null) {
                        from = e.asType();
                    } else {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Could not retrieve type element for " + fromStr);
                    }
                }
                converters.computeIfAbsent(this.toString(typeMirror), c -> new TreeMap(comparator)).put(from, ee);
            }
            TypeElement fallbackAnnotationType = this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.FallbackConverter");
            ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
            for (Element element : roundEnv.getElementsAnnotatedWith(fallbackAnnotationType)) {
                if (element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement ee = (ExecutableElement)element;
                arrayList.add(ee);
            }
            String p = "org.apache.camel.impl.converter";
            String string = "CoreStaticTypeConverterLoader";
            JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(p + "." + string, new Element[0]);
            LinkedHashSet<String> converterClasses = new LinkedHashSet<String>();
            try (Writer writer = jfo.openWriter();){
                writer.append("package ").append(p).append(";\n");
                writer.append("\n");
                writer.append("import org.apache.camel.Exchange;\n");
                writer.append("import org.apache.camel.TypeConversionException;\n");
                writer.append("import org.apache.camel.TypeConverterLoaderException;\n");
                writer.append("import org.apache.camel.spi.TypeConverterLoader;\n");
                writer.append("import org.apache.camel.spi.TypeConverterRegistry;\n");
                writer.append("import org.apache.camel.support.TypeConverterSupport;\n");
                writer.append("\n");
                writer.append("@SuppressWarnings(\"unchecked\")\n");
                writer.append("public class ").append(string).append(" implements TypeConverterLoader {\n");
                writer.append("\n");
                writer.append("    static abstract class SimpleTypeConverter extends TypeConverterSupport {\n");
                writer.append("        private final boolean allowNull;\n");
                writer.append("\n");
                writer.append("        public SimpleTypeConverter(boolean allowNull) {\n");
                writer.append("            this.allowNull = allowNull;\n");
                writer.append("        }\n");
                writer.append("\n");
                writer.append("        @Override\n");
                writer.append("        public boolean allowNull() {\n");
                writer.append("            return allowNull;\n");
                writer.append("        }\n");
                writer.append("\n");
                writer.append("        @Override\n");
                writer.append("        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {\n");
                writer.append("            try {\n");
                writer.append("                return (T) doConvert(exchange, value);\n");
                writer.append("            } catch (TypeConversionException e) {\n");
                writer.append("                throw e;\n");
                writer.append("            } catch (Exception e) {\n");
                writer.append("                throw new TypeConversionException(value, type, e);\n");
                writer.append("            }\n");
                writer.append("        }\n");
                writer.append("        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;\n");
                writer.append("    };\n");
                writer.append("\n");
                writer.append("    @Override\n");
                writer.append("    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {\n");
                for (Map.Entry to : converters.entrySet()) {
                    for (Map.Entry from : ((Map)to.getValue()).entrySet()) {
                        boolean allowNull = false;
                        for (AnnotationMirror annotationMirror : ((ExecutableElement)from.getValue()).getAnnotationMirrors()) {
                            if (annotationMirror.getAnnotationType().asElement() != converterAnnotationType) continue;
                            block30: for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                                switch (entry.getKey().getSimpleName().toString()) {
                                    case "allowNull": {
                                        allowNull = (Boolean)entry.getValue().getValue();
                                        continue block30;
                                    }
                                }
                                throw new IllegalStateException();
                            }
                        }
                        writer.append("        registry.addTypeConverter(").append((CharSequence)to.getKey()).append(".class").append(", ").append(this.toString((TypeMirror)from.getKey())).append(".class, new SimpleTypeConverter(").append(Boolean.toString(allowNull)).append(") {\n");
                        writer.append("            @Override\n");
                        writer.append("            public Object doConvert(Exchange exchange, Object value) throws Exception {\n");
                        writer.append("                return ").append(this.toJava((ExecutableElement)from.getValue(), converterClasses)).append(";\n");
                        writer.append("            }\n");
                        writer.append("        });\n");
                    }
                }
                for (ExecutableElement ee : arrayList) {
                    boolean allowNull = false;
                    boolean canPromote = false;
                    for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
                        if (annotationMirror.getAnnotationType().asElement() != fallbackAnnotationType) continue;
                        block33: for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                            switch (entry.getKey().getSimpleName().toString()) {
                                case "allowNull": {
                                    allowNull = (Boolean)entry.getValue().getValue();
                                    continue block33;
                                }
                                case "canPromote": {
                                    canPromote = (Boolean)entry.getValue().getValue();
                                    continue block33;
                                }
                            }
                            throw new IllegalStateException();
                        }
                    }
                    writer.append("        registry.addFallbackTypeConverter(new TypeConverterSupport() {\n");
                    writer.append("            @Override\n");
                    writer.append("            public boolean allowNull() {\n");
                    writer.append("                return ").append(Boolean.toString(allowNull)).append(";\n");
                    writer.append("            }\n");
                    writer.append("            @Override\n");
                    writer.append("            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {\n");
                    writer.append("                try {\n");
                    writer.append("                    return (T) ").append(this.toJavaFallback(ee, converterClasses)).append(";\n");
                    writer.append("                } catch (TypeConversionException e) {\n");
                    writer.append("                    throw e;\n");
                    writer.append("                } catch (Exception e) {\n");
                    writer.append("                    throw new TypeConversionException(value, type, e);\n");
                    writer.append("                }\n");
                    writer.append("            }\n");
                    writer.append("        }, ").append(Boolean.toString(canPromote)).append(");\n");
                }
                writer.append("\n");
                writer.append("    }\n");
                writer.append("\n");
                for (String f : converterClasses) {
                    String s = f.substring(f.lastIndexOf(46) + 1);
                    String v = s.substring(0, 1).toLowerCase() + s.substring(1);
                    writer.append("    private volatile ").append(f).append(" ").append(v).append(";\n");
                    writer.append("    private ").append(f).append(" get").append(s).append("() {\n");
                    writer.append("        if (").append(v).append(" == null) {\n");
                    writer.append("            synchronized (this) {\n");
                    writer.append("                if (").append(v).append(" == null) {\n");
                    writer.append("                    ").append(v).append(" = new ").append(f).append("();\n");
                    writer.append("                }\n");
                    writer.append("            }\n");
                    writer.append("        }\n");
                    writer.append("        return ").append(v).append(";\n");
                    writer.append("    }\n");
                }
                writer.append("}\n");
                writer.flush();
            }
        }
        catch (Throwable e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to process elements annotated with @Converter: " + e.getMessage());
            ConverterProcessor.dumpExceptionToErrorFile("camel-apt-error.log", "Error processing @Converter", e);
        }
        return false;
    }

    private String toString(TypeMirror type) {
        return type.toString().replaceAll("<.*>", "");
    }

    private String toJava(ExecutableElement converter, Set<String> converterClasses) {
        String pfx;
        if (converter.getModifiers().contains((Object)Modifier.STATIC)) {
            pfx = converter.getEnclosingElement().toString() + "." + converter.getSimpleName();
        } else {
            converterClasses.add(converter.getEnclosingElement().toString());
            pfx = "get" + converter.getEnclosingElement().getSimpleName() + "()." + converter.getSimpleName();
        }
        String type = this.toString(converter.getParameters().get(0).asType());
        String cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(" + cast + "value" + (converter.getParameters().size() == 2 ? ", exchange" : "") + ")";
    }

    private String toJavaFallback(ExecutableElement converter, Set<String> converterClasses) {
        String pfx;
        if (converter.getModifiers().contains((Object)Modifier.STATIC)) {
            pfx = converter.getEnclosingElement().toString() + "." + converter.getSimpleName();
        } else {
            converterClasses.add(converter.getEnclosingElement().toString());
            pfx = "get" + converter.getEnclosingElement().getSimpleName() + "()." + converter.getSimpleName();
        }
        String type = this.toString(converter.getParameters().get(converter.getParameters().size() - 2).asType());
        String cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(type, " + (converter.getParameters().size() == 4 ? "exchange, " : "") + cast + "value, registry)";
    }

    public static void dumpExceptionToErrorFile(String fileName, String message, Throwable e) {
        File file = new File(fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            fos.write(message.getBytes());
            fos.write("\n\n".getBytes());
            fos.write(sw.toString().getBytes());
            pw.close();
            sw.close();
            fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

