/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt.helper;

import java.util.Comparator;
import org.apache.camel.tools.apt.helper.Strings;
import org.apache.camel.tools.apt.model.EndpointOption;
import org.apache.camel.tools.apt.model.EndpointPath;

public final class EndpointHelper {
    private EndpointHelper() {
    }

    public static String labelAsGroupName(String label, boolean consumerOnly, boolean producerOnly) {
        String answer = "common";
        if (consumerOnly) {
            answer = "consumer";
        } else if (producerOnly) {
            answer = "producer";
        }
        String value = label;
        if (!Strings.isNullOrEmpty(value)) {
            if (value.contains("advanced")) {
                value = value.replaceFirst("(\\w),(advanced)", "$1 (advanced)");
            }
            if (value.contains(",")) {
                String[] array = value.split(",");
                answer = array[array.length - 1];
            } else {
                answer = value;
            }
        }
        return answer;
    }

    public static EndpointOptionGroupAndLabelComparator createGroupAndLabelComparator() {
        return new EndpointOptionGroupAndLabelComparator();
    }

    public static EndpointPathComparator createPathComparator(String syntax) {
        return new EndpointPathComparator(syntax);
    }

    private static int groupScore(String group) {
        if ("common".equals(group)) {
            return 1;
        }
        if ("common (advanced)".equals(group)) {
            return 2;
        }
        if ("consumer".equals(group)) {
            return 3;
        }
        if ("consumer (advanced)".equals(group)) {
            return 4;
        }
        if ("producer".equals(group)) {
            return 5;
        }
        if ("producer (advanced)".equals(group)) {
            return 6;
        }
        return 9;
    }

    private static final class EndpointPathComparator
    implements Comparator<EndpointPath> {
        private final String syntax;

        EndpointPathComparator(String syntax) {
            this.syntax = syntax;
        }

        @Override
        public int compare(EndpointPath path1, EndpointPath path2) {
            int pos2;
            int pos1 = this.syntax != null ? this.syntax.indexOf(path1.getName()) : -1;
            int n = pos2 = this.syntax != null ? this.syntax.indexOf(path2.getName()) : -1;
            if (pos1 != -1 && pos2 != -1) {
                return Integer.compare(pos1, pos2);
            }
            return 0;
        }
    }

    private static final class EndpointOptionGroupAndLabelComparator
    implements Comparator<EndpointOption> {
        private EndpointOptionGroupAndLabelComparator() {
        }

        @Override
        public int compare(EndpointOption o1, EndpointOption o2) {
            int score2;
            String name1 = o1.getName();
            String name2 = o2.getName();
            String label1 = o1.getLabel() != null ? o1.getLabel() : "common";
            String label2 = o2.getLabel() != null ? o2.getLabel() : "common";
            String group1 = o1.getGroup();
            String group2 = o2.getGroup();
            if (label1.equalsIgnoreCase(label2) || group1.equalsIgnoreCase(group2)) {
                return name1.compareToIgnoreCase(name2);
            }
            int score1 = EndpointHelper.groupScore(group1);
            if (score1 < (score2 = EndpointHelper.groupScore(group2))) {
                return -1;
            }
            if (score2 < score1) {
                return 1;
            }
            int score = label1.compareToIgnoreCase(label2);
            if (score == 0) {
                score = name1.compareToIgnoreCase(name2);
            }
            return score;
        }
    }
}

