/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.maven.AbstractApiMethodBaseMojo;
import org.apache.camel.maven.ExtraOption;
import org.apache.camel.maven.Substitution;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodParser;
import org.apache.camel.support.component.ArgumentSubstitutionParser;
import org.apache.commons.lang.ClassUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.velocity.VelocityContext;

public abstract class AbstractApiMethodGeneratorMojo
extends AbstractApiMethodBaseMojo {
    private static final Map<Class<?>, String> PRIMITIVE_VALUES = new HashMap();
    @Parameter(required=true, property="org.apache.camel.proxyClass")
    protected String proxyClass;
    private Class<?> proxyType;
    private Pattern propertyNamePattern;
    private Pattern propertyTypePattern;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setCompileSourceRoots();
        Class<?> proxyType = this.getProxyType();
        if (this.excludeConfigNames != null) {
            this.propertyNamePattern = Pattern.compile(this.excludeConfigNames);
        }
        if (this.excludeConfigTypes != null) {
            this.propertyTypePattern = Pattern.compile(this.excludeConfigTypes);
        }
        ApiMethodParser parser = this.createAdapterParser(proxyType);
        parser.setSignatures(this.getSignatureList());
        parser.setClassLoader(this.getProjectClassLoader());
        List models = parser.parse();
        this.mergeTemplate(this.getApiMethodContext(models), this.getApiMethodFile(), "/api-method-enum.vm");
        this.mergeTemplate(this.getEndpointContext(models), this.getConfigurationFile(), "/api-endpoint-config.vm");
        String testFilePath = this.getTestFilePath();
        if (!new File(this.project.getBuild().getTestSourceDirectory(), testFilePath).exists()) {
            this.mergeTemplate(this.getApiTestContext(models), new File(this.generatedTestDir, testFilePath), "/api-route-test.vm");
        }
    }

    protected ApiMethodParser createAdapterParser(Class proxyType) {
        return new ArgumentSubstitutionParser(proxyType, this.getArgumentSubstitutions());
    }

    public abstract List<String> getSignatureList() throws MojoExecutionException;

    public Class<?> getProxyType() throws MojoExecutionException {
        if (this.proxyType == null) {
            try {
                this.proxyType = this.getProjectClassLoader().loadClass(this.proxyClass);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        return this.proxyType;
    }

    private VelocityContext getApiMethodContext(List<ApiMethodParser.ApiMethodModel> models) throws MojoExecutionException {
        VelocityContext context = this.getCommonContext(models);
        context.put("enumName", (Object)this.getEnumName());
        return context;
    }

    public File getApiMethodFile() throws MojoExecutionException {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.outPackage.replaceAll("\\.", Matcher.quoteReplacement(File.separator))).append(File.separator);
        fileName.append(this.getEnumName()).append(".java");
        return new File(this.generatedSrcDir, fileName.toString());
    }

    private String getEnumName() throws MojoExecutionException {
        String proxyClassWithCanonicalName = this.getProxyClassWithCanonicalName(this.proxyClass);
        return proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "ApiMethod";
    }

    private VelocityContext getApiTestContext(List<ApiMethodParser.ApiMethodModel> models) throws MojoExecutionException {
        VelocityContext context = this.getCommonContext(models);
        context.put("testName", (Object)this.getUnitTestName());
        context.put("scheme", (Object)this.scheme);
        context.put("componentPackage", (Object)this.componentPackage);
        context.put("componentName", (Object)this.componentName);
        context.put("enumName", (Object)this.getEnumName());
        return context;
    }

    private String getTestFilePath() throws MojoExecutionException {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.componentPackage.replaceAll("\\.", Matcher.quoteReplacement(File.separator))).append(File.separator);
        fileName.append(this.getUnitTestName()).append(".java");
        return fileName.toString();
    }

    private String getUnitTestName() throws MojoExecutionException {
        String proxyClassWithCanonicalName = this.getProxyClassWithCanonicalName(this.proxyClass);
        return proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "IntegrationTest";
    }

    private VelocityContext getEndpointContext(List<ApiMethodParser.ApiMethodModel> models) throws MojoExecutionException {
        String name;
        VelocityContext context = this.getCommonContext(models);
        context.put("configName", (Object)this.getConfigName());
        context.put("componentName", (Object)this.componentName);
        context.put("componentPackage", (Object)this.componentPackage);
        TreeMap<String, ApiMethodArg> parameters = new TreeMap<String, ApiMethodArg>();
        for (ApiMethodParser.ApiMethodModel model : models) {
            for (ApiMethodArg argument : model.getArguments()) {
                name = argument.getName();
                Class type = argument.getType();
                String typeName = type.getCanonicalName();
                if (parameters.containsKey(name) || this.propertyNamePattern != null && this.propertyNamePattern.matcher(name).matches() || this.propertyTypePattern != null && this.propertyTypePattern.matcher(typeName).matches()) continue;
                parameters.put(name, argument);
            }
        }
        if (this.extraOptions != null && this.extraOptions.length > 0) {
            for (ExtraOption option : this.extraOptions) {
                Class<?> argType;
                name = option.getName();
                String argWithTypes = option.getType().replaceAll(" ", "");
                int rawEnd = argWithTypes.indexOf(60);
                String typeArgs = null;
                try {
                    if (rawEnd != -1) {
                        argType = this.getProjectClassLoader().loadClass(argWithTypes.substring(0, rawEnd));
                        typeArgs = argWithTypes.substring(rawEnd + 1, argWithTypes.lastIndexOf(62));
                    } else {
                        argType = this.getProjectClassLoader().loadClass(argWithTypes);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new MojoExecutionException(String.format("Error loading extra option [%s %s] : %s", argWithTypes, name, e.getMessage()), (Exception)e);
                }
                parameters.put(name, new ApiMethodArg(name, argType, typeArgs));
            }
        }
        context.put("parameters", parameters);
        return context;
    }

    private File getConfigurationFile() throws MojoExecutionException {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.componentPackage.replaceAll("\\.", Matcher.quoteReplacement(File.separator))).append(File.separator);
        fileName.append(this.getConfigName()).append(".java");
        return new File(this.generatedSrcDir, fileName.toString());
    }

    private String getConfigName() throws MojoExecutionException {
        String proxyClassWithCanonicalName = this.getProxyClassWithCanonicalName(this.proxyClass);
        return proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "EndpointConfiguration";
    }

    private String getProxyClassWithCanonicalName(String proxyClass) {
        return proxyClass.replace("$", "");
    }

    private VelocityContext getCommonContext(List<ApiMethodParser.ApiMethodModel> models) throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        context.put("models", models);
        context.put("proxyType", this.getProxyType());
        context.put("helper", (Object)this);
        return context;
    }

    public ArgumentSubstitutionParser.Substitution[] getArgumentSubstitutions() {
        ArgumentSubstitutionParser.Substitution[] subs = new ArgumentSubstitutionParser.Substitution[this.substitutions.length];
        for (int i = 0; i < this.substitutions.length; ++i) {
            Substitution substitution = this.substitutions[i];
            subs[i] = new ArgumentSubstitutionParser.Substitution(substitution.getMethod(), substitution.getArgName(), substitution.getArgType(), substitution.getReplacement(), substitution.isReplaceWithType());
        }
        return subs;
    }

    public static String getType(Class<?> clazz) {
        if (clazz.isArray()) {
            return "new " + AbstractApiMethodGeneratorMojo.getCanonicalName(clazz).replaceAll("\\[\\]", "[0]") + ".getClass()";
        }
        return AbstractApiMethodGeneratorMojo.getCanonicalName(clazz) + ".class";
    }

    public static String getTestName(ApiMethodParser.ApiMethodModel model) {
        StringBuilder builder = new StringBuilder();
        String name = model.getMethod().getName();
        builder.append(Character.toUpperCase(name.charAt(0)));
        builder.append(name.substring(1));
        String uniqueName = model.getUniqueName();
        if (uniqueName.length() > name.length()) {
            builder.append(uniqueName.substring(name.length()));
        }
        return builder.toString();
    }

    public static boolean isVoidType(Class<?> resultType) {
        return resultType == Void.TYPE;
    }

    public String getExchangePropertyPrefix() {
        return "Camel" + this.componentName + ".";
    }

    public static String getResultDeclaration(Class<?> resultType) {
        if (resultType.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(resultType).getSimpleName();
        }
        return AbstractApiMethodGeneratorMojo.getCanonicalName(resultType);
    }

    public static String getDefaultArgValue(Class<?> aClass) {
        if (aClass.isPrimitive()) {
            return PRIMITIVE_VALUES.get(aClass);
        }
        return "null";
    }

    public static String getBeanPropertySuffix(String parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toUpperCase(parameter.charAt(0)));
        builder.append(parameter.substring(1));
        return builder.toString();
    }

    public String getCanonicalName(ApiMethodArg argument) throws MojoExecutionException {
        Class type = argument.getType();
        if (type.isPrimitive()) {
            return AbstractApiMethodGeneratorMojo.getCanonicalName(ClassUtils.primitiveToWrapper((Class)type));
        }
        String canonicalName = AbstractApiMethodGeneratorMojo.getCanonicalName(type);
        String typeArgs = argument.getTypeArgs();
        if (typeArgs != null) {
            StringBuilder parameterizedType = new StringBuilder(canonicalName);
            parameterizedType.append('<');
            String[] argTypes = typeArgs.split(",");
            boolean ignore = false;
            int nTypes = argTypes.length;
            int i = 0;
            for (String argType : argTypes) {
                try {
                    parameterizedType.append(AbstractApiMethodGeneratorMojo.getCanonicalName(this.getProjectClassLoader().loadClass(argType)));
                }
                catch (ClassNotFoundException e) {
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Could not load " + argType + ", trying to load java.lang." + argType);
                        }
                        parameterizedType.append(AbstractApiMethodGeneratorMojo.getCanonicalName(this.getProjectClassLoader().loadClass("java.lang." + argType)));
                    }
                    catch (ClassNotFoundException e1) {
                        this.log.warn("Ignoring type parameters <" + typeArgs + "> for argument " + argument.getName() + ", unable to load parametric type argument " + argType, (Throwable)e1);
                        ignore = true;
                    }
                }
                if (ignore) break;
                if (++i >= nTypes) continue;
                parameterizedType.append(",");
            }
            if (!ignore) {
                parameterizedType.append('>');
                canonicalName = parameterizedType.toString();
            }
        }
        return canonicalName;
    }

    static {
        PRIMITIVE_VALUES.put(Boolean.TYPE, "Boolean.FALSE");
        PRIMITIVE_VALUES.put(Byte.TYPE, "(byte) 0");
        PRIMITIVE_VALUES.put(Character.TYPE, "(char) 0");
        PRIMITIVE_VALUES.put(Short.TYPE, "(short) 0");
        PRIMITIVE_VALUES.put(Integer.TYPE, "0");
        PRIMITIVE_VALUES.put(Long.TYPE, "0L");
        PRIMITIVE_VALUES.put(Float.TYPE, "0.0f");
        PRIMITIVE_VALUES.put(Double.TYPE, "0.0d");
    }
}

