/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    protected static final String PREFIX = "org.apache.camel.";
    protected static final String OUT_PACKAGE = "org.apache.camel.component.internal";
    protected static final String COMPONENT_PACKAGE = "org.apache.camel.component";
    private static VelocityEngine engine;
    private static ClassLoader projectClassLoader;
    private static boolean sharedProjectState;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Parameter(defaultValue="org.apache.camel.component.internal")
    protected String outPackage;
    @Parameter(required=true, property="org.apache.camel.scheme")
    protected String scheme;
    @Parameter(required=true, property="org.apache.camel.componentName")
    protected String componentName;
    @Parameter(required=true, defaultValue="org.apache.camel.component")
    protected String componentPackage;
    @Parameter(required=true, defaultValue="${project}", readonly=true)
    protected MavenProject project;

    protected AbstractGeneratorMojo() {
        AbstractGeneratorMojo.clearSharedProjectState();
    }

    public static void setSharedProjectState(boolean sharedProjectState) {
        AbstractGeneratorMojo.sharedProjectState = sharedProjectState;
    }

    protected static void clearSharedProjectState() {
        if (!sharedProjectState) {
            projectClassLoader = null;
        }
    }

    protected static VelocityEngine getEngine() throws MojoExecutionException {
        if (engine == null) {
            Properties velocityProperties = new Properties();
            velocityProperties.setProperty("resource.loader", "cloader");
            velocityProperties.setProperty("cloader.resource.loader.class", ClasspathResourceLoader.class.getName());
            Logger velocityLogger = LoggerFactory.getLogger((String)"org.apache.camel.maven.Velocity");
            velocityProperties.setProperty("runtime.log.name", velocityLogger.getName());
            try {
                engine = new VelocityEngine(velocityProperties);
                engine.init();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        return engine;
    }

    protected ClassLoader getProjectClassLoader() throws MojoExecutionException {
        if (projectClassLoader == null) {
            List classpathElements;
            try {
                classpathElements = this.project.getTestClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            URL[] urls = new URL[classpathElements.size()];
            int i = 0;
            Iterator it = classpathElements.iterator();
            while (it.hasNext()) {
                try {
                    urls[i] = new File((String)it.next()).toURI().toURL();
                    this.log.debug("Adding project path " + urls[i]);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                ++i;
            }
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            projectClassLoader = new URLClassLoader(urls, tccl != null ? tccl : ((Object)((Object)this)).getClass().getClassLoader());
        }
        return projectClassLoader;
    }

    protected void mergeTemplate(VelocityContext context, File outFile, String templateName) throws MojoExecutionException {
        Template template;
        File outDir = outFile.getParentFile();
        if (!outDir.isDirectory() && !outDir.mkdirs()) {
            throw new MojoExecutionException("Error creating directory " + outDir);
        }
        context.put("generatedDate", (Object)new Date().toString());
        context.put("packageName", (Object)this.outPackage);
        context.put("newLine", (Object)"\n");
        try {
            template = AbstractGeneratorMojo.getEngine().getTemplate(templateName, "UTF-8");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        try {
            StringWriter writer = new StringWriter();
            template.merge((Context)context, (Writer)writer);
            AbstractGeneratorMojo.updateResource(null, outFile.toPath(), writer.toString());
        }
        catch (VelocityException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static String getCanonicalName(Class<?> type) {
        String canonicalName = type.getCanonicalName();
        int pkgEnd = canonicalName.lastIndexOf(46);
        if (pkgEnd > 0 && canonicalName.substring(0, pkgEnd).equals("java.lang")) {
            canonicalName = canonicalName.substring(pkgEnd + 1);
        }
        return canonicalName;
    }

    public static void updateResource(BuildContext buildContext, Path out, String data) {
        block17: {
            try {
                String content;
                if (data == null) {
                    if (Files.isRegularFile(out, new LinkOption[0])) {
                        Files.delete(out);
                        AbstractGeneratorMojo.refresh(buildContext, out);
                    }
                    break block17;
                }
                if (Files.isRegularFile(out, new LinkOption[0]) && Files.isReadable(out) && Objects.equals(content = new String(Files.readAllBytes(out), StandardCharsets.UTF_8), data)) {
                    return;
                }
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                try (BufferedWriter w = Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]);){
                    w.append(data);
                }
                AbstractGeneratorMojo.refresh(buildContext, out);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public static void refresh(BuildContext buildContext, Path file) {
        if (buildContext != null) {
            buildContext.refresh(file.toFile());
        }
    }
}

