/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.cw.CwComponentVerifierExtension;
import org.apache.camel.component.aws.cw.CwConfiguration;
import org.apache.camel.component.aws.cw.CwEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-cw")
public class CwComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private CwConfiguration configuration;

    public CwComponent() {
        this(null);
    }

    public CwComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new CwComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Metric namespace must be specified.");
        }
        CwConfiguration configuration = this.configuration != null ? this.configuration.copy() : new CwConfiguration();
        configuration.setNamespace(remaining);
        CwEndpoint endpoint = new CwEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonCwClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonCwClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public CwConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CwConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(CwConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonCloudWatch.class);
        if (clients.size() == 1) {
            configuration.setAmazonCwClient((AmazonCloudWatch)clients.stream().findFirst().get());
        }
    }
}

