/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.BatchGetItemsCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;
import org.apache.camel.component.aws.ddb.DdbEndpoint;
import org.apache.camel.component.aws.ddb.DdbOperations;
import org.apache.camel.component.aws.ddb.DeleteItemCommand;
import org.apache.camel.component.aws.ddb.DeleteTableCommand;
import org.apache.camel.component.aws.ddb.DescribeTableCommand;
import org.apache.camel.component.aws.ddb.GetItemCommand;
import org.apache.camel.component.aws.ddb.PutItemCommand;
import org.apache.camel.component.aws.ddb.QueryCommand;
import org.apache.camel.component.aws.ddb.ScanCommand;
import org.apache.camel.component.aws.ddb.UpdateItemCommand;
import org.apache.camel.component.aws.ddb.UpdateTableCommand;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;

public class DdbProducer
extends DefaultProducer {
    public DdbProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case BatchGetItems: {
                new BatchGetItemsCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DeleteItem: {
                new DeleteItemCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DeleteTable: {
                new DeleteTableCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DescribeTable: {
                new DescribeTableCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case GetItem: {
                new GetItemCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case PutItem: {
                new PutItemCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case Query: {
                new QueryCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case Scan: {
                new ScanCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case UpdateItem: {
                new UpdateItemCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case UpdateTable: {
                new UpdateTableCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private DdbOperations determineOperation(Exchange exchange) {
        DdbOperations operation = (DdbOperations)((Object)exchange.getIn().getHeader("CamelAwsDdbOperation", DdbOperations.class));
        return operation != null ? operation : this.getConfiguration().getOperation();
    }

    protected DdbConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        return "DdbProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }

    public DdbEndpoint getEndpoint() {
        return (DdbEndpoint)super.getEndpoint();
    }
}

