/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StaticService;
import org.apache.camel.spi.ExtendedRoutesBuilderLoader;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesBuilderLoader;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class DefaultRoutesLoader
extends ServiceSupport
implements RoutesLoader,
StaticService {
    public static final String ROUTES_LOADER_KEY_PREFIX = "routes-builder-loader-";
    private final Map<String, RoutesBuilderLoader> loaders;
    private CamelContext camelContext;

    public DefaultRoutesLoader() {
        this(null);
    }

    public DefaultRoutesLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.loaders = new ConcurrentHashMap<String, RoutesBuilderLoader>();
    }

    public void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.loaders.values());
        this.loaders.clear();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Collection<RoutesBuilder> findRoutesBuilders(Collection<Resource> resources) throws Exception {
        RoutesBuilderLoader loader;
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>(resources.size());
        if (this.camelContext.isModeline().booleanValue()) {
            ModelineFactory factory = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getModelineFactory();
            for (Resource resource : resources) {
                loader = this.resolveRoutesBuilderLoader(resource);
                factory.parseModeline(resource);
                loader.preParseRoute(resource);
            }
        }
        LinkedHashMap<RoutesBuilderLoader, List> groups = new LinkedHashMap<RoutesBuilderLoader, List>();
        for (Resource resource : resources) {
            loader = this.resolveRoutesBuilderLoader(resource);
            List list = groups.getOrDefault(loader, new ArrayList());
            list.add(resource);
            groups.put(loader, list);
        }
        for (Map.Entry entry : groups.entrySet()) {
            loader = (RoutesBuilderLoader)entry.getKey();
            if (loader instanceof ExtendedRoutesBuilderLoader) {
                ExtendedRoutesBuilderLoader extLoader = (ExtendedRoutesBuilderLoader)loader;
                Collection builders = extLoader.loadRoutesBuilders((Collection)entry.getValue());
                if (builders == null) continue;
                answer.addAll(builders);
                continue;
            }
            for (Resource resource : (List)entry.getValue()) {
                RoutesBuilder builder = loader.loadRoutesBuilder(resource);
                if (builder == null) continue;
                answer.add(builder);
            }
        }
        return answer;
    }

    public void preParseRoute(Resource resource) throws Exception {
        this.resolveRoutesBuilderLoader(resource).preParseRoute(resource);
    }

    public RoutesBuilderLoader getRoutesLoader(String extension) throws Exception {
        RoutesBuilderLoader answer = (RoutesBuilderLoader)this.getCamelContext().getRegistry().lookupByNameAndType(ROUTES_LOADER_KEY_PREFIX + extension, RoutesBuilderLoader.class);
        if (answer == null) {
            answer = this.loaders.computeIfAbsent(extension, this::resolveService);
        }
        return answer;
    }

    protected RoutesBuilderLoader resolveService(String extension) {
        FactoryFinder finder;
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class);
        RoutesBuilderLoader answer = ResolverHelper.resolveService((CamelContext)ecc, (FactoryFinder)(finder = ecc.getBootstrapFactoryFinder("META-INF/services/org/apache/camel/routes-loader/")), (String)extension, RoutesBuilderLoader.class).orElse(null);
        if (answer != null) {
            CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)this.getCamelContext());
            this.initRoutesBuilderLoader(answer);
            ServiceHelper.startService((Object)answer);
        }
        return answer;
    }

    public Set<String> updateRoutes(Collection<Resource> resources) throws Exception {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        Collection<RoutesBuilder> builders = this.findRoutesBuilders(resources);
        for (RoutesBuilder builder : builders) {
            if (!(builder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)builder;
            rcb.updateRouteConfigurationsToCamelContext(this.getCamelContext());
        }
        for (RoutesBuilder builder : builders) {
            Set ids = builder.updateRoutesToCamelContext(this.getCamelContext());
            answer.addAll(ids);
        }
        return answer;
    }

    protected RoutesBuilderLoader resolveRoutesBuilderLoader(Resource resource) throws Exception {
        String extension = FileUtil.onlyExt((String)resource.getLocation(), (boolean)false);
        if (ObjectHelper.isEmpty((String)extension)) {
            throw new IllegalArgumentException("Unable to determine file extension for resource: " + resource.getLocation());
        }
        RoutesBuilderLoader loader = this.getRoutesLoader(extension);
        if (loader == null) {
            throw new IllegalArgumentException("Cannot find RoutesBuilderLoader in classpath supporting file extension: " + extension);
        }
        return loader;
    }
}

