/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.engine.AbstractDynamicRegistry;
import org.apache.camel.impl.engine.ValidatorKey;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultValidatorRegistry
extends AbstractDynamicRegistry<ValidatorKey, Validator>
implements ValidatorRegistry<ValidatorKey> {
    public DefaultValidatorRegistry(CamelContext context) {
        super(context, CamelContextHelper.getMaximumValidatorCacheSize((CamelContext)context));
    }

    public Validator resolveValidator(ValidatorKey key) {
        Validator answer = (Validator)this.get((Object)key);
        if (answer == null && ObjectHelper.isNotEmpty((String)key.getType().getName())) {
            answer = (Validator)this.get((Object)new ValidatorKey(new DataType(key.getType().getScheme())));
        }
        return answer;
    }

    @Override
    public boolean isStatic(DataType type) {
        return this.isStatic(new ValidatorKey(type));
    }

    @Override
    public boolean isDynamic(DataType type) {
        return this.isDynamic(new ValidatorKey(type));
    }

    @Override
    public String toString() {
        return "ValidatorRegistry for " + this.context.getName() + " [capacity: " + this.maxCacheSize + "]";
    }

    @Override
    public Validator put(ValidatorKey key, Validator obj) {
        ServiceHelper.startService((Object)obj);
        return super.put(key, obj);
    }
}

