/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.TimeUtils;

public abstract class DefaultRoute
extends ServiceSupport
implements Route {
    private final Endpoint endpoint;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<Service> services = new ArrayList<Service>();
    private final RouteContext routeContext;
    private Date startDate;

    public DefaultRoute(RouteContext routeContext, Endpoint endpoint) {
        this.routeContext = routeContext;
        this.endpoint = endpoint;
    }

    public DefaultRoute(RouteContext routeContext, Endpoint endpoint, Service ... services) {
        this(routeContext, endpoint);
        for (Service service : services) {
            this.addService(service);
        }
    }

    public String toString() {
        return "Route " + this.getId();
    }

    public String getId() {
        return (String)this.properties.get("id");
    }

    public String getGroup() {
        return (String)this.properties.get("group");
    }

    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "";
        }
        return TimeUtils.printDuration((double)delta);
    }

    public long getUptimeMillis() {
        if (this.startDate == null) {
            return 0L;
        }
        return new Date().getTime() - this.startDate.getTime();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    public CamelContext getCamelContext() {
        return this.routeContext.getCamelContext();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getDescription() {
        Object value = this.properties.get("description");
        return value != null ? value.toString() : null;
    }

    public void onStartingServices(List<Service> services) throws Exception {
        this.addServices(services);
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void addService(Service service) {
        if (!this.services.contains(service)) {
            this.services.add(service);
        }
    }

    public void warmUp() {
        this.getServices().clear();
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    protected void addServices(List<Service> services) throws Exception {
    }

    protected void doStart() throws Exception {
        this.startDate = new Date();
    }

    protected void doStop() throws Exception {
        this.startDate = null;
    }

    protected void doShutdown() throws Exception {
        this.startDate = null;
        this.services.clear();
    }
}

