/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;

public class DefaultShutdownStrategy
extends ServiceSupport
implements ShutdownStrategy,
CamelContextAware {
    private CamelContext camelContext;
    private ExecutorService executor;
    private long timeout = 300L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private boolean shutdownNowOnTimeout = true;
    private boolean shutdownRoutesInReverseOrder = true;
    private boolean suppressLoggingOnTimeout;
    private boolean logInflightExchangesOnTimeout = true;
    private volatile boolean forceShutdown;
    private final AtomicBoolean timeoutOccurred = new AtomicBoolean();
    private volatile Future<?> currentShutdownTaskFuture;

    public DefaultShutdownStrategy() {
    }

    public DefaultShutdownStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void shutdown(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.shutdown(context, routes, this.getTimeout(), this.getTimeUnit());
    }

    public void shutdownForced(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.doShutdown(context, routes, this.getTimeout(), this.getTimeUnit(), false, false, true);
    }

    public void suspend(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.doShutdown(context, routes, this.getTimeout(), this.getTimeUnit(), true, false, false);
    }

    public void shutdown(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdown(context, routes, timeout, timeUnit, false, false, false);
    }

    public boolean shutdown(CamelContext context, RouteStartupOrder route, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        List<RouteStartupOrder> routes = Collections.singletonList(route);
        return this.doShutdown(context, routes, timeout, timeUnit, false, abortAfterTimeout, false);
    }

    public void suspend(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdown(context, routes, timeout, timeUnit, true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doShutdown(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit, boolean suspendOnly, boolean abortAfterTimeout, boolean forceShutdown) throws Exception {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be a positive value");
        }
        if (routes.isEmpty()) {
            return true;
        }
        StopWatch watch = new StopWatch();
        Comparator<RouteStartupOrder> comparator = Comparator.comparingInt(RouteStartupOrder::getStartupOrder);
        if (this.shutdownRoutesInReverseOrder) {
            comparator = comparator.reversed();
        }
        ArrayList<RouteStartupOrder> routesOrdered = new ArrayList<RouteStartupOrder>(routes);
        routesOrdered.sort(comparator);
        if (suspendOnly) {
            this.log.info("Starting to graceful suspend {} routes (timeout {} {})", new Object[]{routesOrdered.size(), timeout, timeUnit.toString().toLowerCase(Locale.ENGLISH)});
        } else {
            this.log.info("Starting to graceful shutdown {} routes (timeout {} {})", new Object[]{routesOrdered.size(), timeout, timeUnit.toString().toLowerCase(Locale.ENGLISH)});
        }
        this.timeoutOccurred.set(false);
        this.currentShutdownTaskFuture = this.getExecutorService().submit(new ShutdownTask(context, routesOrdered, timeout, timeUnit, suspendOnly, abortAfterTimeout, this.timeoutOccurred, this.isLogInflightExchangesOnTimeout()));
        try {
            this.currentShutdownTaskFuture.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e.getCause());
        }
        catch (Exception e) {
            this.timeoutOccurred.set(true);
            this.currentShutdownTaskFuture.cancel(true);
            this.forceShutdown = forceShutdown;
            if (!forceShutdown && abortAfterTimeout) {
                this.log.warn("Timeout occurred during graceful shutdown. Aborting the shutdown now. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                this.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
                boolean bl = false;
                return bl;
            }
            if (forceShutdown || this.shutdownNowOnTimeout) {
                this.log.warn("Timeout occurred during graceful shutdown. Forcing the routes to be shutdown now. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                this.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
                this.shutdownRoutesNow(routesOrdered);
                for (RouteStartupOrder order : routes) {
                    for (Service service : order.getServices()) {
                        this.prepareShutdown(service, false, true, true, this.isSuppressLoggingOnTimeout());
                    }
                }
            } else {
                this.log.warn("Timeout occurred during graceful shutdown. Will ignore shutting down the remainder routes. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                this.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
            }
        }
        finally {
            this.currentShutdownTaskFuture = null;
        }
        long seconds = TimeUnit.SECONDS.convert(watch.taken(), TimeUnit.MILLISECONDS);
        this.log.info("Graceful shutdown of {} routes completed in {} seconds", (Object)routesOrdered.size(), (Object)seconds);
        return true;
    }

    public boolean forceShutdown(Service service) {
        return this.forceShutdown;
    }

    public boolean hasTimeoutOccurred() {
        return this.timeoutOccurred.get();
    }

    public void setTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be a positive value");
        }
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.shutdownNowOnTimeout = shutdownNowOnTimeout;
    }

    public boolean isShutdownNowOnTimeout() {
        return this.shutdownNowOnTimeout;
    }

    public boolean isShutdownRoutesInReverseOrder() {
        return this.shutdownRoutesInReverseOrder;
    }

    public void setShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
        this.shutdownRoutesInReverseOrder = shutdownRoutesInReverseOrder;
    }

    public boolean isSuppressLoggingOnTimeout() {
        return this.suppressLoggingOnTimeout;
    }

    public void setSuppressLoggingOnTimeout(boolean suppressLoggingOnTimeout) {
        this.suppressLoggingOnTimeout = suppressLoggingOnTimeout;
    }

    public boolean isLogInflightExchangesOnTimeout() {
        return this.logInflightExchangesOnTimeout;
    }

    public void setLogInflightExchangesOnTimeout(boolean logInflightExchangesOnTimeout) {
        this.logInflightExchangesOnTimeout = logInflightExchangesOnTimeout;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Future<?> getCurrentShutdownTaskFuture() {
        return this.currentShutdownTaskFuture;
    }

    protected void shutdownRoutesNow(List<RouteStartupOrder> routes) {
        for (RouteStartupOrder order : routes) {
            ShutdownRunningTask current = order.getRoute().getRouteContext().getShutdownRunningTask();
            if (current != ShutdownRunningTask.CompleteCurrentTaskOnly) {
                this.log.debug("Changing shutdownRunningTask from {} to " + ShutdownRunningTask.CompleteCurrentTaskOnly + " on route {} to shutdown faster", (Object)current, (Object)order.getRoute().getId());
                order.getRoute().getRouteContext().setShutdownRunningTask(ShutdownRunningTask.CompleteCurrentTaskOnly);
            }
            for (Consumer consumer : order.getInputs()) {
                this.shutdownNow(consumer);
            }
        }
    }

    protected void shutdownNow(List<Consumer> consumers) {
        for (Consumer consumer : consumers) {
            this.shutdownNow(consumer);
        }
    }

    protected void shutdownNow(Consumer consumer) {
        this.log.trace("Shutting down: {}", (Object)consumer);
        try {
            ServiceHelper.stopService((Object)consumer);
        }
        catch (Throwable e) {
            this.log.warn("Error occurred while shutting down route: " + consumer + ". This exception will be ignored.", e);
            EventHelper.notifyServiceStopFailure((CamelContext)consumer.getEndpoint().getCamelContext(), (Object)consumer, (Throwable)e);
        }
        this.log.trace("Shutdown complete for: {}", (Object)consumer);
    }

    protected void suspendNow(Consumer consumer) {
        this.log.trace("Suspending: {}", (Object)consumer);
        try {
            ServiceHelper.suspendService((Object)consumer);
        }
        catch (Throwable e) {
            this.log.warn("Error occurred while suspending route: " + consumer + ". This exception will be ignored.", e);
            EventHelper.notifyServiceStopFailure((CamelContext)consumer.getEndpoint().getCamelContext(), (Object)consumer, (Throwable)e);
        }
        this.log.trace("Suspend complete for: {}", (Object)consumer);
    }

    private ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = this.camelContext.getExecutorServiceManager().newThreadPool((Object)this, "ShutdownTask", 0, 1);
        }
        return this.executor;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        this.forceShutdown = false;
        this.timeoutOccurred.set(false);
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        if (this.executor != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    private void prepareShutdown(Service service, boolean suspendOnly, boolean forced, boolean includeChildren, boolean suppressLogging) {
        LinkedHashSet<Service> list;
        if (includeChildren) {
            list = ServiceHelper.getChildServices((Service)service, (boolean)true);
        } else {
            list = new LinkedHashSet<Service>(1);
            list.add(service);
        }
        for (Service child : list) {
            if (!(child instanceof ShutdownPrepared)) continue;
            try {
                this.log.trace("Preparing {} shutdown on {}", (Object)(forced ? "forced" : ""), (Object)child);
                ((ShutdownPrepared)child).prepareShutdown(suspendOnly, forced);
            }
            catch (Exception e) {
                if (suppressLogging) {
                    this.log.trace("Error during prepare shutdown on " + child + ". This exception will be ignored.", (Throwable)e);
                    continue;
                }
                this.log.warn("Error during prepare shutdown on " + child + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    protected static int getPendingInflightExchanges(RouteStartupOrder order) {
        int inflight = 0;
        for (Service service : order.getServices()) {
            Set children = ServiceHelper.getChildServices((Service)service);
            for (Service child : children) {
                if (!(child instanceof ShutdownAware)) continue;
                inflight += ((ShutdownAware)child).getPendingExchangesSize();
            }
        }
        return inflight;
    }

    protected void logInflightExchanges(CamelContext camelContext, List<RouteStartupOrder> routes, boolean infoLevel) {
        if (!infoLevel && !this.log.isDebugEnabled()) {
            return;
        }
        Collection inflights = camelContext.getInflightRepository().browse();
        int size = inflights.size();
        if (size == 0) {
            return;
        }
        HashSet<String> routeIds = new HashSet<String>();
        for (RouteStartupOrder routeStartupOrder : routes) {
            routeIds.add(routeStartupOrder.getRoute().getId());
        }
        ArrayList<InflightRepository.InflightExchange> filtered = new ArrayList<InflightRepository.InflightExchange>();
        for (InflightRepository.InflightExchange inflight : inflights) {
            String routeId = inflight.getExchange().getFromRouteId();
            if (!routeIds.contains(routeId)) continue;
            filtered.add(inflight);
        }
        size = filtered.size();
        if (size == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("There are " + size + " inflight exchanges:");
        for (InflightRepository.InflightExchange inflight : filtered) {
            stringBuilder.append("\n\tInflightExchange: [exchangeId=").append(inflight.getExchange().getExchangeId()).append(", fromRouteId=").append(inflight.getExchange().getFromRouteId()).append(", atRouteId=").append(inflight.getAtRouteId()).append(", nodeId=").append(inflight.getNodeId()).append(", elapsed=").append(inflight.getElapsed()).append(", duration=").append(inflight.getDuration()).append("]");
        }
        if (infoLevel) {
            this.log.info(stringBuilder.toString());
        } else {
            this.log.debug(stringBuilder.toString());
        }
    }

    class ShutdownTask
    implements Runnable {
        private final CamelContext context;
        private final List<RouteStartupOrder> routes;
        private final boolean suspendOnly;
        private final boolean abortAfterTimeout;
        private final long timeout;
        private final TimeUnit timeUnit;
        private final AtomicBoolean timeoutOccurred;
        private final boolean logInflightExchangesOnTimeout;

        ShutdownTask(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit, boolean suspendOnly, boolean abortAfterTimeout, AtomicBoolean timeoutOccurred, boolean logInflightExchangesOnTimeout) {
            this.context = context;
            this.routes = routes;
            this.suspendOnly = suspendOnly;
            this.abortAfterTimeout = abortAfterTimeout;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            this.timeoutOccurred = timeoutOccurred;
            this.logInflightExchangesOnTimeout = logInflightExchangesOnTimeout;
        }

        @Override
        public void run() {
            DefaultShutdownStrategy.this.log.debug("There are {} routes to {}", (Object)this.routes.size(), (Object)(this.suspendOnly ? "suspend" : "shutdown"));
            ArrayList<ShutdownDeferredConsumer> deferredConsumers = new ArrayList<ShutdownDeferredConsumer>();
            for (RouteStartupOrder order : this.routes) {
                ShutdownRoute shutdownRoute = order.getRoute().getRouteContext().getShutdownRoute();
                ShutdownRunningTask shutdownRunningTask = order.getRoute().getRouteContext().getShutdownRunningTask();
                if (DefaultShutdownStrategy.this.log.isTraceEnabled()) {
                    DefaultShutdownStrategy.this.log.trace("{}{} with options [{},{}]", new Object[]{this.suspendOnly ? "Suspending route: " : "Shutting down route: ", order.getRoute().getId(), shutdownRoute, shutdownRunningTask});
                }
                for (Consumer consumer : order.getInputs()) {
                    boolean shutdown;
                    boolean suspend = false;
                    boolean bl = shutdown = shutdownRoute != ShutdownRoute.Defer;
                    if (shutdown) {
                        if (consumer instanceof ShutdownAware) {
                            boolean bl2 = shutdown = !((ShutdownAware)consumer).deferShutdown(shutdownRunningTask);
                        }
                        if (shutdown && consumer instanceof Suspendable) {
                            suspend = true;
                        }
                    }
                    if (suspend) {
                        DefaultShutdownStrategy.this.suspendNow(consumer);
                        deferredConsumers.add(new ShutdownDeferredConsumer(order.getRoute(), consumer));
                        DefaultShutdownStrategy.this.log.debug("Route: {} suspended and shutdown deferred, was consuming from: {}", (Object)order.getRoute().getId(), (Object)order.getRoute().getEndpoint());
                        continue;
                    }
                    if (shutdown) {
                        DefaultShutdownStrategy.this.shutdownNow(consumer);
                        DefaultShutdownStrategy.this.log.info("Route: {} shutdown complete, was consuming from: {}", (Object)order.getRoute().getId(), (Object)order.getRoute().getEndpoint());
                        continue;
                    }
                    deferredConsumers.add(new ShutdownDeferredConsumer(order.getRoute(), consumer));
                    DefaultShutdownStrategy.this.log.debug("Route: " + order.getRoute().getId() + (this.suspendOnly ? " shutdown deferred." : " suspension deferred."));
                }
            }
            for (RouteStartupOrder order : this.routes) {
                for (Service service : order.getServices()) {
                    if (service instanceof Consumer) continue;
                    DefaultShutdownStrategy.this.prepareShutdown(service, this.suspendOnly, false, true, false);
                }
            }
            boolean done = false;
            long loopDelaySeconds = 1L;
            long loopCount = 0L;
            while (!done && !this.timeoutOccurred.get()) {
                int size = 0;
                LinkedHashMap<String, Integer> routeInflight = new LinkedHashMap<String, Integer>();
                for (RouteStartupOrder routeStartupOrder : this.routes) {
                    int inflight = this.context.getInflightRepository().size(routeStartupOrder.getRoute().getId());
                    if ((inflight += DefaultShutdownStrategy.getPendingInflightExchanges(routeStartupOrder)) <= 0) continue;
                    String routeId = routeStartupOrder.getRoute().getId();
                    routeInflight.put(routeId, inflight);
                    size += inflight;
                    DefaultShutdownStrategy.this.log.trace("{} inflight and pending exchanges for route: {}", (Object)inflight, (Object)routeId);
                }
                if (size > 0) {
                    try {
                        CollectionStringBuffer csb = new CollectionStringBuffer();
                        for (Map.Entry entry : routeInflight.entrySet()) {
                            String row = String.format("%s = %s", entry.getKey(), entry.getValue());
                            csb.append((Object)row);
                        }
                        String string2 = "Waiting as there are still " + size + " inflight and pending exchanges to complete, timeout in " + (TimeUnit.SECONDS.convert(this.timeout, this.timeUnit) - loopCount++ * loopDelaySeconds) + " seconds.";
                        string2 = string2 + " Inflights per route: [" + csb.toString() + "]";
                        DefaultShutdownStrategy.this.log.info(string2);
                        DefaultShutdownStrategy.this.logInflightExchanges(this.context, this.routes, this.logInflightExchangesOnTimeout);
                        Thread.sleep(loopDelaySeconds * 1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        if (this.abortAfterTimeout) {
                            DefaultShutdownStrategy.this.log.warn("Interrupted while waiting during graceful shutdown, will abort.");
                            return;
                        }
                        DefaultShutdownStrategy.this.log.warn("Interrupted while waiting during graceful shutdown, will force shutdown now.");
                        break;
                    }
                }
                done = true;
            }
            for (ShutdownDeferredConsumer deferred : deferredConsumers) {
                Consumer consumer = deferred.getConsumer();
                if (!(consumer instanceof ShutdownAware)) continue;
                DefaultShutdownStrategy.this.log.trace("Route: {} preparing to shutdown.", (Object)deferred.getRoute().getId());
                boolean bl = this.context.getShutdownStrategy().forceShutdown((Service)consumer);
                boolean suppress = this.context.getShutdownStrategy().isSuppressLoggingOnTimeout();
                DefaultShutdownStrategy.this.prepareShutdown((Service)consumer, this.suspendOnly, bl, false, suppress);
                DefaultShutdownStrategy.this.log.debug("Route: {} preparing to shutdown complete.", (Object)deferred.getRoute().getId());
            }
            for (ShutdownDeferredConsumer deferred : deferredConsumers) {
                Consumer consumer = deferred.getConsumer();
                if (this.suspendOnly) {
                    DefaultShutdownStrategy.this.suspendNow(consumer);
                    DefaultShutdownStrategy.this.log.info("Route: {} suspend complete, was consuming from: {}", (Object)deferred.getRoute().getId(), (Object)deferred.getConsumer().getEndpoint());
                    continue;
                }
                DefaultShutdownStrategy.this.shutdownNow(consumer);
                DefaultShutdownStrategy.this.log.info("Route: {} shutdown complete, was consuming from: {}", (Object)deferred.getRoute().getId(), (Object)deferred.getConsumer().getEndpoint());
            }
            for (RouteStartupOrder order : this.routes) {
                for (Service service : order.getServices()) {
                    boolean forced = this.context.getShutdownStrategy().forceShutdown(service);
                    boolean suppress = this.context.getShutdownStrategy().isSuppressLoggingOnTimeout();
                    DefaultShutdownStrategy.this.prepareShutdown(service, this.suspendOnly, forced, true, suppress);
                }
            }
        }
    }

    static class ShutdownDeferredConsumer {
        private final Route route;
        private final Consumer consumer;

        ShutdownDeferredConsumer(Route route, Consumer consumer) {
            this.route = route;
            this.consumer = consumer;
        }

        Route getRoute() {
            return this.route;
        }

        Consumer getConsumer() {
            return this.consumer;
        }
    }
}

