/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;

public final class PipelineHelper {
    private PipelineHelper() {
    }

    public static boolean continueProcessing(Exchange exchange, String message, Logger log) {
        boolean doStop;
        boolean exceptionHandled = ExchangeHelper.hasExceptionBeenHandledByErrorHandler((Exchange)exchange);
        if (exchange.isFailed() || exchange.isRollbackOnly() || exceptionHandled) {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Message exchange has failed: ").append(message).append(" for exchange: ").append(exchange);
                if (exchange.isRollbackOnly()) {
                    sb.append(" Marked as rollback only.");
                }
                if (exchange.getException() != null) {
                    sb.append(" Exception: ").append(exchange.getException());
                }
                if (exceptionHandled) {
                    sb.append(" Handled by the error handler.");
                }
                log.debug(sb.toString());
            }
            return false;
        }
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = ((Boolean)exchange.getContext().getTypeConverter().convertTo(Boolean.class, exchange, stop)).booleanValue())) {
            log.debug("ExchangeId: {} is marked to stop routing: {}", (Object)exchange.getExchangeId(), (Object)exchange);
            return false;
        }
        return true;
    }
}

