/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.NamedNode;
import org.apache.camel.spi.NodeIdFactory;

public class DefaultNodeIdFactory
implements NodeIdFactory {
    protected static Map<String, AtomicInteger> nodeCounters = new ConcurrentHashMap<String, AtomicInteger>();

    public String createId(NamedNode definition) {
        String key = definition.getShortName();
        return key + DefaultNodeIdFactory.getNodeCounter(key).incrementAndGet();
    }

    protected static AtomicInteger getNodeCounter(String key) {
        return nodeCounters.computeIfAbsent(key, k -> new AtomicInteger(0));
    }

    protected static void resetAllCounters() {
        for (AtomicInteger counter : nodeCounters.values()) {
            counter.set(0);
        }
    }
}

