/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.Date;
import java.util.TimeZone;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.DateTimeConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class DateTimeConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        DateTimeConverterLoader.addTypeConverter(registry, Long.class, Date.class, false, (type, exchange, value) -> DateTimeConverter.toLong((Date)value));
        DateTimeConverterLoader.addTypeConverter(registry, Date.class, Long.class, false, (type, exchange, value) -> DateTimeConverter.toDate((Long)value));
        DateTimeConverterLoader.addTypeConverter(registry, TimeZone.class, String.class, false, (type, exchange, value) -> DateTimeConverter.toTimeZone((String)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

