/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.PropertiesLookupListener;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesParser
implements PropertiesParser {
    private static final String UNRESOLVED_PREFIX_TOKEN = "@@[";
    private static final String UNRESOLVED_SUFFIX_TOKEN = "]@@";
    private static final String GET_OR_ELSE_TOKEN = ":";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private PropertiesComponent propertiesComponent;

    public DefaultPropertiesParser() {
    }

    public DefaultPropertiesParser(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    public PropertiesComponent getPropertiesComponent() {
        return this.propertiesComponent;
    }

    public void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    @Override
    public String parseUri(String text, PropertiesLookup properties, boolean defaultFallbackEnabled, boolean keepUnresolvedOptional, boolean nestedPlaceholder) throws IllegalArgumentException {
        ParsingContext context = new ParsingContext(properties, defaultFallbackEnabled, keepUnresolvedOptional, nestedPlaceholder);
        String answer = context.parse(text);
        if (keepUnresolvedOptional && answer != null && answer.contains(UNRESOLVED_PREFIX_TOKEN)) {
            answer = answer.replace(UNRESOLVED_PREFIX_TOKEN, "{{");
            answer = answer.replace(UNRESOLVED_SUFFIX_TOKEN, "}}");
        }
        return answer;
    }

    @Override
    public String parseProperty(String key, String value, PropertiesLookup properties) {
        return value;
    }

    private void onLookup(String name, String value, String defaultValue, String source) {
        for (PropertiesLookupListener listener : this.propertiesComponent.getPropertiesLookupListeners()) {
            try {
                listener.onLookup(name, value, defaultValue, source);
            }
            catch (Exception exception) {}
        }
    }

    private static String location(Properties prop, String name, String defaultLocation) {
        String loc = null;
        if (prop instanceof OrderedLocationProperties) {
            loc = ((OrderedLocationProperties)prop).getLocation((Object)name);
        }
        if (loc == null) {
            loc = defaultLocation;
        }
        return loc;
    }

    private final class ParsingContext {
        private final PropertiesLookup properties;
        private final boolean defaultFallbackEnabled;
        private final boolean keepUnresolvedOptional;
        private final boolean nestedPlaceholder;

        ParsingContext(PropertiesLookup properties, boolean defaultFallbackEnabled, boolean keepUnresolvedOptional, boolean nestedPlaceholder) {
            this.properties = properties;
            this.defaultFallbackEnabled = defaultFallbackEnabled;
            this.keepUnresolvedOptional = keepUnresolvedOptional;
            this.nestedPlaceholder = nestedPlaceholder;
        }

        public String parse(String input) {
            boolean nested = this.nestedPlaceholder;
            if (input.contains("?nested=true")) {
                nested = true;
                input = input.replace("?nested=true", "");
            } else if (input.contains("?nested=false")) {
                nested = false;
                input = input.replace("?nested=false", "");
            }
            if (nested) {
                return this.doParseNested(input, new HashSet<String>());
            }
            return this.doParse(input);
        }

        private String doParse(String input) {
            Property property;
            if (input == null) {
                return null;
            }
            StringBuilder answer = new StringBuilder();
            while ((property = this.readProperty(input)) != null) {
                String before = input.substring(0, property.getBeginIndex());
                String after = input.substring(property.getEndIndex());
                String parsed = property.getValue();
                if (parsed != null) {
                    answer.append(before);
                    answer.append(parsed);
                } else if (property.getBeginIndex() == 0 && input.length() == property.getEndIndex()) {
                    return null;
                }
                input = after;
            }
            if (!input.isEmpty()) {
                answer.append(input);
            }
            return answer.toString();
        }

        private String doParseNested(String input, Set<String> replacedPropertyKeys) {
            Property property;
            if (input == null) {
                return null;
            }
            Object answer = input;
            while ((property = this.readProperty((String)answer)) != null) {
                if (replacedPropertyKeys.contains(property.getKey())) {
                    boolean optional = property.getKey().startsWith("?");
                    if (optional) break;
                    throw new IllegalArgumentException("Circular reference detected with key [" + property.getKey() + "] from text: " + input);
                }
                HashSet<String> newReplaced = new HashSet<String>(replacedPropertyKeys);
                newReplaced.add(property.getKey());
                int beginIndex = property.getBeginIndex();
                if (beginIndex > 0 && ((String)answer).charAt(beginIndex - 1) == '\\') {
                    --beginIndex;
                }
                String before = ((String)answer).substring(0, beginIndex);
                String after = ((String)answer).substring(property.getEndIndex());
                String parsed = this.doParseNested(property.getValue(), newReplaced);
                if (parsed != null) {
                    answer = before + parsed + after;
                    continue;
                }
                if (beginIndex == 0 && input.length() == property.getEndIndex()) {
                    answer = null;
                    break;
                }
                answer = before + after;
            }
            return answer;
        }

        private Property readProperty(String input) {
            int suffix = this.getSuffixIndex(input);
            if (suffix == -1) {
                if (this.getMatchingPrefixIndex(input, input.length()) != -1) {
                    throw new IllegalArgumentException(String.format("Missing %s from the text: %s", "}}", input));
                }
                return null;
            }
            int prefix = this.getMatchingPrefixIndex(input, suffix);
            if (prefix == -1) {
                throw new IllegalArgumentException(String.format("Missing %s from the text: %s", "{{", input));
            }
            String key = input.substring(prefix + "{{".length(), suffix);
            String value = this.getPropertyValue(key, input);
            return new Property(prefix, suffix + "}}".length(), key, value);
        }

        private int getSuffixIndex(String input) {
            int index = -1;
            while ((index = input.indexOf("}}", index + 1)) != -1 && (this.isQuoted(input, index, "}}") || this.isEscaped(input, index - 1))) {
            }
            return index;
        }

        private int getMatchingPrefixIndex(String input, int suffixIndex) {
            int index = suffixIndex;
            while ((index = input.lastIndexOf("{{", index - 1)) != -1 && (this.isQuoted(input, index, "{{") || this.isEscaped(input, index - 1))) {
            }
            return index;
        }

        private boolean isQuoted(String input, int index, String token) {
            int beforeIndex = index - 1;
            int afterIndex = index + token.length();
            if (beforeIndex >= 0 && afterIndex < input.length()) {
                char after;
                char before = input.charAt(beforeIndex);
                return before == (after = input.charAt(afterIndex)) && (before == '\'' || before == '\"');
            }
            return false;
        }

        private boolean isEscaped(String input, int index) {
            if (index >= 0) {
                return input.charAt(index) == '\\' && (index == 0 || input.charAt(index - 1) != '\\');
            }
            return false;
        }

        private String getPropertyValue(String key, String input) {
            String value;
            boolean optional;
            String prefix;
            PropertiesFunction function;
            if (DefaultPropertiesParser.this.propertiesComponent != null && (function = DefaultPropertiesParser.this.propertiesComponent.getPropertiesFunction(prefix = StringHelper.before((String)key, (String)DefaultPropertiesParser.GET_OR_ELSE_TOKEN))) != null) {
                String remainder = StringHelper.after((String)key, (String)DefaultPropertiesParser.GET_OR_ELSE_TOKEN);
                if (function.lookupFirst(remainder)) {
                    boolean optional2 = remainder != null && remainder.startsWith("?");
                    String value2 = this.getPropertyValue(remainder, input);
                    if (optional2 && value2 == null) {
                        return null;
                    }
                    if (value2 != null && value2.startsWith(DefaultPropertiesParser.UNRESOLVED_PREFIX_TOKEN)) {
                        return value2;
                    }
                    remainder = value2;
                }
                DefaultPropertiesParser.this.log.debug("Property with key [{}] is applied by function [{}]", (Object)key, (Object)function.getName());
                String value3 = function.apply(remainder);
                if (value3 == null) {
                    throw new IllegalArgumentException("Property with key [" + key + "] using function [" + function.getName() + "] returned null value which is not allowed, from input: " + input);
                }
                if (DefaultPropertiesParser.this.log.isDebugEnabled()) {
                    DefaultPropertiesParser.this.log.debug("Property with key [{}] applied by function [{}] -> {}", new Object[]{key, function.getName(), value3});
                }
                return value3;
            }
            String defaultValue = null;
            if (this.defaultFallbackEnabled && key.contains(DefaultPropertiesParser.GET_OR_ELSE_TOKEN)) {
                defaultValue = StringHelper.after((String)key, (String)DefaultPropertiesParser.GET_OR_ELSE_TOKEN);
                key = StringHelper.before((String)key, (String)DefaultPropertiesParser.GET_OR_ELSE_TOKEN);
            }
            boolean bl = optional = key != null && key.startsWith("?");
            if (optional) {
                key = key.substring("?".length());
            }
            if ((value = this.doGetPropertyValue(key)) == null && defaultValue != null) {
                DefaultPropertiesParser.this.log.debug("Property with key [{}] not found, using default value: {}", (Object)key, (Object)defaultValue);
                value = defaultValue;
            }
            if (value == null) {
                if (!optional && DefaultPropertiesParser.this.propertiesComponent != null && DefaultPropertiesParser.this.propertiesComponent.isIgnoreMissingProperty()) {
                    return DefaultPropertiesParser.UNRESOLVED_PREFIX_TOKEN + key + DefaultPropertiesParser.UNRESOLVED_SUFFIX_TOKEN;
                }
                if (!optional) {
                    StringBuilder esb = new StringBuilder();
                    esb.append("Property with key [").append(key).append("] ");
                    esb.append("not found in properties from text: ").append(input);
                    throw new IllegalArgumentException(esb.toString());
                }
                if (this.keepUnresolvedOptional) {
                    return "@@[?" + key + DefaultPropertiesParser.UNRESOLVED_SUFFIX_TOKEN;
                }
                return null;
            }
            return value;
        }

        private String doGetPropertyValue(String key) {
            String answer;
            int sysMode;
            Properties local;
            if (ObjectHelper.isEmpty((String)key)) {
                return DefaultPropertiesParser.this.parseProperty(key, null, this.properties);
            }
            String value = null;
            Properties properties = local = DefaultPropertiesParser.this.propertiesComponent != null ? DefaultPropertiesParser.this.propertiesComponent.getLocalProperties() : null;
            if (local != null && (value = local.getProperty(key)) != null) {
                Object val;
                String defaultValue = null;
                String loc = DefaultPropertiesParser.location(local, key, "LocalProperties");
                if (local instanceof OrderedLocationProperties && (val = ((OrderedLocationProperties)local).getDefaultValue((Object)key)) != null) {
                    defaultValue = (String)DefaultPropertiesParser.this.propertiesComponent.getCamelContext().getTypeConverter().tryConvertTo(String.class, val);
                }
                DefaultPropertiesParser.this.onLookup(key, value, defaultValue, loc);
                DefaultPropertiesParser.this.log.debug("Found local property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            int envMode = DefaultPropertiesParser.this.propertiesComponent != null ? DefaultPropertiesParser.this.propertiesComponent.getEnvironmentVariableMode() : 1;
            int n = sysMode = DefaultPropertiesParser.this.propertiesComponent != null ? DefaultPropertiesParser.this.propertiesComponent.getSystemPropertiesMode() : 2;
            if (value == null && envMode == 2 && (value = IOHelper.lookupEnvironmentVariable((String)key)) != null) {
                DefaultPropertiesParser.this.onLookup(key, value, null, "ENV");
                DefaultPropertiesParser.this.log.debug("Found an OS environment property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && sysMode == 2 && (value = System.getProperty(key)) != null) {
                DefaultPropertiesParser.this.onLookup(key, value, null, "SYS");
                DefaultPropertiesParser.this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && this.properties != null && (value = this.properties.lookup(key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && (value = DefaultPropertiesParser.this.customLookup(key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found property (custom lookup): {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && envMode == 1 && (value = IOHelper.lookupEnvironmentVariable((String)key)) != null) {
                DefaultPropertiesParser.this.onLookup(key, value, null, "ENV");
                DefaultPropertiesParser.this.log.debug("Found an OS environment property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && sysMode == 1 && (value = System.getProperty(key)) != null) {
                DefaultPropertiesParser.this.onLookup(key, value, null, "SYS");
                DefaultPropertiesParser.this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if ((answer = DefaultPropertiesParser.this.parseProperty(key, value, this.properties)) == null) {
                answer = value;
            }
            return answer;
        }
    }

    private static final class Property {
        private final int beginIndex;
        private final int endIndex;
        private final String key;
        private final String value;

        private Property(int beginIndex, int endIndex, String key, String value) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.key = key;
            this.value = value;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

