/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.CsvRecord;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.OneToMany;
import org.apache.camel.dataformat.bindy.annotation.Section;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyCsvFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(BindyCsvFactory.class);
    boolean isOneToMany;
    private Map<Integer, DataField> dataFields = new LinkedHashMap<Integer, DataField>();
    private Map<Integer, Field> annotatedFields = new LinkedHashMap<Integer, Field>();
    private Map<String, Integer> sections = new HashMap<String, Integer>();
    private int numberOptionalFields;
    private int numberMandatoryFields;
    private int totalFields;
    private String separator;
    private boolean skipFirstLine;
    private boolean generateHeaderColumnNames;
    private boolean messageOrdered;
    private String quote;
    private boolean quoting;

    public BindyCsvFactory(PackageScanClassResolver resolver, String ... packageNames) throws Exception {
        super(resolver, packageNames);
        this.initCsvModel();
    }

    public BindyCsvFactory(PackageScanClassResolver resolver, Class<?> type) throws Exception {
        super(resolver, type);
        this.initCsvModel();
    }

    public void initCsvModel() throws Exception {
        this.initAnnotatedFields();
        this.initCsvRecordParameters();
    }

    @Override
    public void initAnnotatedFields() {
        int maxpos = 0;
        for (Class cl : this.models) {
            ArrayList<Field> linkFields = new ArrayList<Field>();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class retrieved: {}", (Object)cl.getName());
            }
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                DataField dataField = field.getAnnotation(DataField.class);
                if (dataField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Position defined in the class: {}, position: {}, Field: {}", new Object[]{cl.getName(), dataField.pos(), dataField});
                    }
                    if (dataField.required()) {
                        ++this.numberMandatoryFields;
                    } else {
                        ++this.numberOptionalFields;
                    }
                    int pos = dataField.pos();
                    if (this.annotatedFields.containsKey(pos)) {
                        Field f = this.annotatedFields.get(pos);
                        LOG.warn("Potentially invalid model: existing @DataField '{}' replaced by '{}'", (Object)f.getName(), (Object)field.getName());
                    }
                    this.dataFields.put(pos, dataField);
                    this.annotatedFields.put(pos, field);
                    maxpos = Math.max(maxpos, pos);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Class linked: {}, Field: {}", (Object)cl.getName(), (Object)field);
                }
                linkFields.add(field);
            }
            if (!linkFields.isEmpty()) {
                this.annotatedLinkFields.put(cl.getName(), linkFields);
            }
            this.totalFields = this.numberMandatoryFields + this.numberOptionalFields;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Number of optional fields: {}", (Object)this.numberOptionalFields);
            LOG.debug("Number of mandatory fields: {}", (Object)this.numberMandatoryFields);
            LOG.debug("Total: {}", (Object)this.totalFields);
        }
        if (this.annotatedFields.size() < maxpos) {
            LOG.info("Potentially incomplete model: some csv fields may not be mapped to @DataField members");
        }
    }

    @Override
    public void bind(List<String> tokens, Map<String, Object> model, int line) throws Exception {
        int pos = 1;
        int counterMandatoryFields = 0;
        for (String data : tokens) {
            DataField dataField = this.dataFields.get(pos);
            ObjectHelper.notNull((Object)dataField, (String)("No position " + pos + " defined for the field: " + data + ", line: " + line));
            if (dataField.trim()) {
                data = data.trim();
            }
            if (dataField.required()) {
                ++counterMandatoryFields;
                if (data.equals("")) {
                    throw new IllegalArgumentException("The mandatory field defined at the position " + pos + " is empty for the line: " + line);
                }
            }
            Field field = this.annotatedFields.get(pos);
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pos: {}, Data: {}, Field type: {}", new Object[]{pos, data, field.getType()});
            }
            Format<?> format = FormatFactory.getFormat(field.getType(), this.getLocale(), dataField);
            Object modelField = model.get(field.getDeclaringClass().getName());
            Object value = null;
            if (!data.equals("")) {
                try {
                    value = format.parse(data);
                }
                catch (FormatException ie) {
                    throw new IllegalArgumentException(ie.getMessage() + ", position: " + pos + ", line: " + line, ie);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Parsing error detected for field defined at the position: " + pos + ", line: " + line, e);
                }
            } else {
                value = !dataField.defaultValue().isEmpty() ? format.parse(dataField.defaultValue()) : BindyCsvFactory.getDefaultValueForPrimitive(field.getType());
            }
            field.set(modelField, value);
            ++pos;
        }
        LOG.debug("Counter mandatory fields: {}", (Object)counterMandatoryFields);
        if (counterMandatoryFields < this.numberMandatoryFields) {
            throw new IllegalArgumentException("Some mandatory fields are missing, line: " + line);
        }
        if (pos < this.totalFields) {
            this.setDefaultValuesForFields(model);
        }
    }

    @Override
    public String unbind(Map<String, Object> model) throws Exception {
        StringBuilder buffer = new StringBuilder();
        HashMap<Integer, List<String>> results = new HashMap<Integer, List<String>>();
        ObjectHelper.notNull((Object)this.separator, (String)"The separator has not been instantiated or property not defined in the @CsvRecord annotation");
        char separator = ConverterUtils.getCharDelimiter(this.getSeparator());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Separator converted: '0x{}', from: {}", (Object)Integer.toHexString(separator), (Object)this.getSeparator());
        }
        for (Class clazz : this.models) {
            if (!model.containsKey(clazz.getName())) continue;
            Object obj = model.get(clazz.getName());
            if (obj != null && LOG.isDebugEnabled()) {
                LOG.debug("Model object: {}, class: {}", obj, (Object)obj.getClass().getName());
            }
            if (obj == null) continue;
            this.generateCsvPositionMap(clazz, obj, results);
        }
        List<Object> l = new ArrayList();
        if (this.isOneToMany) {
            l = this.product(results);
        } else {
            TreeMap<Integer, List<String>> sortValues = new TreeMap<Integer, List<String>>(results);
            ArrayList<String> temp = new ArrayList<String>();
            for (Map.Entry<Integer, List<String>> entry : sortValues.entrySet()) {
                List<String> val = entry.getValue();
                String value = val.get(0);
                if (value != null) {
                    temp.add(value);
                    continue;
                }
                temp.add("");
            }
            l.add(temp);
        }
        if (l != null) {
            Iterator<Object> it = l.iterator();
            while (it.hasNext()) {
                List tokens = (List)it.next();
                Iterator itx = tokens.iterator();
                while (itx.hasNext()) {
                    String res = (String)itx.next();
                    if (res != null) {
                        if (this.quoting && this.quote != null) {
                            buffer.append(this.quote);
                        }
                        buffer.append(res);
                        if (this.quoting && this.quote != null) {
                            buffer.append(this.quote);
                        }
                    }
                    if (!itx.hasNext()) continue;
                    buffer.append(separator);
                }
                if (!it.hasNext()) continue;
                buffer.append(ConverterUtils.getStringCarriageReturn(this.getCarriageReturn()));
            }
        }
        return buffer.toString();
    }

    private List<List<String>> product(Map<Integer, List<String>> values) {
        TreeMap<Integer, List<String>> sortValues = new TreeMap<Integer, List<String>>(values);
        ArrayList<List<String>> product = new ArrayList<List<String>>();
        HashMap<Integer, Integer> index = new HashMap<Integer, Integer>();
        int idx = 0;
        int idxSize = 0;
        do {
            idxSize = 0;
            ArrayList<String> v = new ArrayList<String>();
            for (int ii = 1; ii <= sortValues.lastKey(); ++ii) {
                List<String> l = values.get(ii);
                if (l == null) {
                    v.add("");
                    ++idxSize;
                    continue;
                }
                if (l.size() >= idx + 1) {
                    v.add(l.get(idx));
                    index.put(ii, idx);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Value: {}, pos: {}, at: {}", new Object[]{l.get(idx), ii, idx});
                    continue;
                }
                v.add(l.get(0));
                index.put(ii, 0);
                ++idxSize;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Value: {}, pos: {}, at index: {}", new Object[]{l.get(0), ii, 0});
            }
            if (idxSize != sortValues.lastKey()) {
                product.add(v);
            }
            ++idx;
        } while (idxSize != sortValues.lastKey());
        return product;
    }

    private void generateCsvPositionMap(Class<?> clazz, Object obj, Map<Integer, List<String>> results) throws Exception {
        String result = "";
        for (Field field : clazz.getDeclaredFields()) {
            OneToMany oneToMany;
            List<Object> list;
            field.setAccessible(true);
            DataField datafield = field.getAnnotation(DataField.class);
            if (datafield != null) {
                Integer key;
                if (obj != null) {
                    Class<?> type = field.getType();
                    Format<?> format = FormatFactory.getFormat(type, this.getLocale(), datafield);
                    Object value = field.get(obj);
                    result = this.formatString(format, value);
                    if (datafield.trim()) {
                        result = result.trim();
                    }
                    if (datafield.clip() && result.length() > datafield.length()) {
                        result = result.substring(0, datafield.length());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Value to be formatted: {}, position: {}, and its formatted value: {}", new Object[]{value, datafield.pos(), result});
                    }
                } else {
                    result = "";
                }
                if (this.isMessageOrdered() && obj != null) {
                    Integer key1 = this.sections.get(obj.getClass().getName());
                    Integer key2 = datafield.position();
                    Integer n = BindyCsvFactory.generateKey(key1, key2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Key generated: {}, for section: {}", (Object)String.valueOf(n), (Object)key1);
                    }
                    key = n;
                } else {
                    key = datafield.pos();
                }
                if (!results.containsKey(key)) {
                    list = new LinkedList<String>();
                    list.add(result);
                    results.put(key, list);
                } else {
                    list = results.get(key);
                    list.add(result);
                }
            }
            if ((oneToMany = field.getAnnotation(OneToMany.class)) == null) continue;
            this.isOneToMany = true;
            list = (LinkedList<String>)field.get(obj);
            if (list != null) {
                for (Object e : list) {
                    this.generateCsvPositionMap(e.getClass(), e, results);
                }
                continue;
            }
            this.generateCsvPositionMap(field.getClass(), null, results);
        }
    }

    public String generateHeader() {
        TreeMap<Integer, DataField> dataFieldsSorted = new TreeMap<Integer, DataField>(this.dataFields);
        Iterator it = dataFieldsSorted.keySet().iterator();
        StringBuilder builderHeader = new StringBuilder();
        while (it.hasNext()) {
            DataField dataField = (DataField)dataFieldsSorted.get(it.next());
            Field field = this.annotatedFields.get(dataField.pos());
            field.setAccessible(true);
            if (!dataField.columnName().equals("")) {
                builderHeader.append(dataField.columnName());
            } else {
                builderHeader.append(field.getName());
            }
            if (!it.hasNext()) continue;
            builderHeader.append(this.separator);
        }
        return builderHeader.toString();
    }

    private void initCsvRecordParameters() {
        if (this.separator == null) {
            for (Class cl : this.models) {
                CsvRecord record = cl.getAnnotation(CsvRecord.class);
                Section section = cl.getAnnotation(Section.class);
                if (record != null) {
                    LOG.debug("Csv record: {}", (Object)record);
                    this.skipFirstLine = record.skipFirstLine();
                    LOG.debug("Skip First Line parameter of the CSV: {}" + this.skipFirstLine);
                    this.generateHeaderColumnNames = record.generateHeaderColumns();
                    LOG.debug("Generate header column names parameter of the CSV: {}", (Object)this.generateHeaderColumnNames);
                    ObjectHelper.notNull((Object)record.separator(), (String)"No separator has been defined in the @Record annotation");
                    this.separator = record.separator();
                    LOG.debug("Separator defined for the CSV: {}", (Object)this.separator);
                    this.crlf = record.crlf();
                    LOG.debug("Carriage return defined for the CSV: {}", (Object)this.crlf);
                    this.messageOrdered = record.isOrdered();
                    LOG.debug("Must CSV record be ordered: {}", (Object)this.messageOrdered);
                    if (ObjectHelper.isNotEmpty((Object)record.quote())) {
                        this.quote = record.quote();
                        LOG.debug("Quoting columns with: {}", (Object)this.quote);
                    }
                    this.quoting = record.quoting();
                    LOG.debug("CSV will be quoted: {}", (Object)this.messageOrdered);
                }
                if (section == null) continue;
                ObjectHelper.notNull((Object)section.number(), (String)"No number has been defined for the section");
                this.sections.put(cl.getName(), section.number());
            }
        }
    }

    private void setDefaultValuesForFields(Map<String, Object> model) throws IllegalAccessException, Exception {
        for (int i = 1; i <= this.dataFields.size(); ++i) {
            Field field = this.annotatedFields.get(i);
            field.setAccessible(true);
            DataField dataField = this.dataFields.get(i);
            Object modelField = model.get(field.getDeclaringClass().getName());
            if (field.get(modelField) != null || dataField.defaultValue().isEmpty()) continue;
            Format<?> format = FormatFactory.getFormat(field.getType(), this.getLocale(), dataField);
            Object value = format.parse(dataField.defaultValue());
            field.set(modelField, value);
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean getGenerateHeaderColumnNames() {
        return this.generateHeaderColumnNames;
    }

    public boolean getSkipFirstLine() {
        return this.skipFirstLine;
    }

    public boolean isMessageOrdered() {
        return this.messageOrdered;
    }

    public String getQuote() {
        return this.quote;
    }
}

