/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.PatternFormat;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class LocalDateTimeFormatFactory
extends AbstractFormatFactory {
    public LocalDateTimeFormatFactory() {
        this.supportedClasses.add(LocalDateTime.class);
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new LocalDateTimePatternFormat(formattingOptions.getPattern(), formattingOptions.getTimezone(), formattingOptions.getLocale());
    }

    private static class LocalDateTimePatternFormat
    implements PatternFormat<LocalDateTime> {
        private String pattern;
        private Locale locale;
        private ZoneId zone;

        LocalDateTimePatternFormat(String pattern, String timezone, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
            this.zone = timezone.isEmpty() ? ZoneId.systemDefault() : ZoneId.of(timezone);
        }

        @Override
        public String format(LocalDateTime object) throws Exception {
            ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
            return this.getDateFormat().format(object);
        }

        @Override
        public LocalDateTime parse(String string) throws Exception {
            DateTimeFormatter df = this.getDateFormat();
            ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
            if (this.doesStringFitLengthOfPattern(string)) {
                LocalDateTime date = LocalDateTime.parse(string, df);
                return date;
            }
            throw new FormatException("Date provided does not fit the pattern defined");
        }

        private boolean doesStringFitLengthOfPattern(String string) {
            return string.length() <= this.pattern.length();
        }

        DateTimeFormatter getDateFormat() {
            DateTimeFormatter result = this.locale != null ? DateTimeFormatter.ofPattern(this.pattern, this.locale).withZone(this.zone) : DateTimeFormatter.ofPattern(this.pattern).withZone(this.zone);
            return result;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

