/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.factories.BigDecimalFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.BigDecimalPatternFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.BigIntegerFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.BooleanFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.ByteFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.BytePatternFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.CharacterFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.DateFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.DoubleFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.DoublePatternFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.EnumFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.FactoryRegistry;
import org.apache.camel.dataformat.bindy.format.factories.FloatFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.FloatPatternFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.FormatFactoryInterface;
import org.apache.camel.dataformat.bindy.format.factories.IntegerFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.IntegerPatternFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.LocalDateFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.LocalDateTimeFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.LocalTimeFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.LongFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.LongPatternFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.ShortFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.ShortPatternFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.StringFormatFactory;
import org.apache.camel.dataformat.bindy.format.factories.ZonedDateTimeFormatFactory;

public final class DefaultFactoryRegistry
implements FactoryRegistry {
    private final Map<Class<?>, List<FormatFactoryInterface>> classBasedFactories = new HashMap();
    private final List<FormatFactoryInterface> otherFactories = new ArrayList<FormatFactoryInterface>();

    public DefaultFactoryRegistry() {
        this.register(new StringFormatFactory()).register(new DateFormatFactory()).register(new BooleanFormatFactory()).register(new BigIntegerFormatFactory()).register(new LocalTimeFormatFactory()).register(new LocalDateTimeFormatFactory()).register(new LocalDateFormatFactory()).register(new ZonedDateTimeFormatFactory()).register(new CharacterFormatFactory()).register(new EnumFormatFactory()).register(new BigDecimalFormatFactory()).register(new BigDecimalPatternFormatFactory()).register(new DoubleFormatFactory()).register(new DoublePatternFormatFactory()).register(new FloatFormatFactory()).register(new FloatPatternFormatFactory()).register(new LongFormatFactory()).register(new LongPatternFormatFactory()).register(new IntegerFormatFactory()).register(new IntegerPatternFormatFactory()).register(new ShortFormatFactory()).register(new ShortPatternFormatFactory()).register(new ByteFormatFactory()).register(new BytePatternFormatFactory());
    }

    @Override
    public FactoryRegistry register(FormatFactoryInterface ... formatFactories) {
        for (FormatFactoryInterface formatFactory : formatFactories) {
            if (formatFactory.supportedClasses().isEmpty()) {
                for (FormatFactoryInterface formatFactoryInterface : this.otherFactories) {
                    if (formatFactoryInterface.getClass() != formatFactory.getClass()) continue;
                    return this;
                }
                this.otherFactories.add(formatFactory);
                continue;
            }
            for (Class clazz : formatFactory.supportedClasses()) {
                List<FormatFactoryInterface> factories = this.getByClass(clazz);
                for (FormatFactoryInterface factory : factories) {
                    if (factory.getClass() != formatFactory.getClass()) continue;
                    return this;
                }
                factories.add(formatFactory);
            }
        }
        return this;
    }

    @Override
    public FactoryRegistry unregister(Class<? extends FormatFactoryInterface> clazz) {
        for (Map.Entry<Class<?>, List<FormatFactoryInterface>> entry : this.classBasedFactories.entrySet()) {
            entry.getValue().removeIf(factory -> factory.getClass() == clazz);
        }
        return this;
    }

    @Override
    public FormatFactoryInterface findForFormattingOptions(FormattingOptions formattingOptions) {
        for (FormatFactoryInterface formatFactory : this.getByClass(formattingOptions.getClazz())) {
            if (!formatFactory.canBuild(formattingOptions)) continue;
            return formatFactory;
        }
        for (FormatFactoryInterface formatFactory : this.otherFactories) {
            if (!formatFactory.canBuild(formattingOptions)) continue;
            return formatFactory;
        }
        throw new IllegalArgumentException("Can not findForFormattingOptions a suitable formatter for the type: " + formattingOptions.getClazz().getCanonicalName());
    }

    private List<FormatFactoryInterface> getByClass(Class<?> clazz) {
        List<FormatFactoryInterface> result = this.classBasedFactories.get(clazz);
        if (result == null) {
            result = new ArrayList<FormatFactoryInterface>();
            this.classBasedFactories.put(clazz, result);
        }
        return result;
    }
}

