/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.PatternFormat;

public abstract class NumberPatternFormat<T>
implements PatternFormat<T> {
    private String pattern;
    private Locale locale;
    private String decimalSeparator;
    private String groupingSeparator;
    private int precision;
    private String rounding;

    public NumberPatternFormat() {
    }

    public NumberPatternFormat(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
    }

    public NumberPatternFormat(String pattern, Locale locale, int precision, String rounding, String decimalSeparator, String groupingSeparator) {
        this.pattern = pattern;
        this.locale = locale;
        this.decimalSeparator = decimalSeparator;
        this.groupingSeparator = groupingSeparator;
        this.precision = precision;
        this.rounding = rounding;
    }

    @Override
    public String format(T object) throws Exception {
        if (this.getNumberFormat() != null) {
            return this.getNumberFormat().format(object);
        }
        return object.toString();
    }

    @Override
    public abstract T parse(String var1) throws Exception;

    protected NumberFormat getNumberFormat() {
        if (this.locale == null) {
            return null;
        }
        NumberFormat format = NumberFormat.getNumberInstance(this.locale);
        if (format instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)format;
            if (this.decimalSeparator != null && this.groupingSeparator != null && !this.decimalSeparator.isEmpty() && !this.groupingSeparator.isEmpty()) {
                DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.locale);
                dfs.setDecimalSeparator(this.decimalSeparator.charAt(0));
                dfs.setGroupingSeparator(this.groupingSeparator.charAt(0));
                df.setDecimalFormatSymbols(dfs);
            }
            if (!this.pattern.isEmpty()) {
                df.applyPattern(this.pattern);
            }
        }
        return format;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getRounding() {
        return this.rounding;
    }

    public void setRounding(String rounding) {
        this.rounding = rounding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

