/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.blueprint.BlueprintPropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.util.ObjectHelper;

public class BlueprintPropertiesResolver
implements PropertiesResolver {
    private final PropertiesResolver delegate;
    private final BlueprintPropertiesParser blueprint;

    public BlueprintPropertiesResolver(PropertiesResolver delegate, BlueprintPropertiesParser blueprint) {
        this.delegate = delegate;
        this.blueprint = blueprint;
    }

    public Properties resolveProperties(CamelContext context, String ... urls) throws Exception {
        Properties answer = new Properties();
        boolean explicit = false;
        for (String url : urls) {
            if (url.startsWith("blueprint:")) {
                String ref = ObjectHelper.after((String)url, (String)"blueprint:");
                this.blueprint.addPropertyPlaceholder(ref);
                explicit = true;
                continue;
            }
            answer.putAll((Map<?, ?>)this.delegate.resolveProperties(context, new String[]{url}));
        }
        if (!explicit) {
            String[] ids;
            for (String id : ids = this.blueprint.lookupPropertyPlaceholderIds()) {
                this.blueprint.addPropertyPlaceholder(id);
            }
        }
        return answer;
    }
}

