/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaResolver;
import org.apache.camel.catalog.impl.CatalogHelper;

public class CamelCatalogJSonSchemaResolver
implements JSonSchemaResolver {
    private static final String MODEL_DIR = "org/apache/camel/catalog/models";
    public static final String EXTENSION = ".json";
    private final CamelCatalog camelCatalog;
    private ClassLoader classLoader;
    private final Map<String, String> extraComponents;
    private final Map<String, String> extraComponentsJSonSchema;
    private final Map<String, String> extraDataFormats;
    private final Map<String, String> extraDataFormatsJSonSchema;

    public CamelCatalogJSonSchemaResolver(CamelCatalog camelCatalog, Map<String, String> extraComponents, Map<String, String> extraComponentsJSonSchema, Map<String, String> extraDataFormats, Map<String, String> extraDataFormatsJSonSchema) {
        this.camelCatalog = camelCatalog;
        this.extraComponents = extraComponents;
        this.extraComponentsJSonSchema = extraComponentsJSonSchema;
        this.extraDataFormats = extraDataFormats;
        this.extraDataFormatsJSonSchema = extraDataFormatsJSonSchema;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getComponentJSonSchema(String name) {
        String file = this.camelCatalog.getRuntimeProvider().getComponentJSonSchemaDirectory() + "/" + name + EXTENSION;
        String fromVersionManager = this.loadResourceFromVersionManager(file);
        if (fromVersionManager != null) {
            return fromVersionManager;
        }
        String answer = this.extraComponentsJSonSchema.get(name);
        if (answer != null) {
            return answer;
        }
        String className = this.extraComponents.get(name);
        return this.loadFromClasspath(className, name);
    }

    public String getDataFormatJSonSchema(String name) {
        String file = this.camelCatalog.getRuntimeProvider().getDataFormatJSonSchemaDirectory() + "/" + name + EXTENSION;
        String fromVersionManager = this.loadResourceFromVersionManager(file);
        if (fromVersionManager != null) {
            return fromVersionManager;
        }
        String schema = this.extraDataFormatsJSonSchema.get(name);
        if (schema != null) {
            return schema;
        }
        String className = this.extraDataFormats.get(name);
        return this.loadFromClasspath(className, name);
    }

    public String getLanguageJSonSchema(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String file = this.camelCatalog.getRuntimeProvider().getLanguageJSonSchemaDirectory() + "/" + name + EXTENSION;
        return this.loadResourceFromVersionManager(file);
    }

    public String getTransformerJSonSchema(String name) {
        name = this.sanitizeFileName(name);
        String file = this.camelCatalog.getRuntimeProvider().getTransformerJSonSchemaDirectory() + "/" + name + EXTENSION;
        return this.loadResourceFromVersionManager(file);
    }

    public String getDevConsoleJSonSchema(String name) {
        name = this.sanitizeFileName(name);
        String file = this.camelCatalog.getRuntimeProvider().getDevConsoleJSonSchemaDirectory() + "/" + name + EXTENSION;
        return this.loadResourceFromVersionManager(file);
    }

    public String getModelJSonSchema(String name) {
        String file = "org/apache/camel/catalog/models/" + name + EXTENSION;
        return this.loadResourceFromVersionManager(file);
    }

    public String getMainJsonSchema() {
        String file = "org/apache/camel/catalog/main/camel-main-configuration-metadata.json";
        return this.loadResourceFromVersionManager("org/apache/camel/catalog/main/camel-main-configuration-metadata.json");
    }

    public String getOtherJSonSchema(String name) {
        String file = this.camelCatalog.getRuntimeProvider().getOtherJSonSchemaDirectory() + "/" + name + EXTENSION;
        return this.loadResourceFromVersionManager(file);
    }

    public String getPojoBeanJSonSchema(String name) {
        name = this.sanitizeFileName(name);
        String file = this.camelCatalog.getRuntimeProvider().getPojoBeanJSonSchemaDirectory() + "/" + name + EXTENSION;
        return this.loadResourceFromVersionManager(file);
    }

    String loadFromClasspath(String className, String fileName) {
        if (className != null) {
            String packageName = className.substring(0, className.lastIndexOf(46));
            packageName = packageName.replace('.', '/');
            String path = packageName + "/" + fileName + EXTENSION;
            return this.loadResourceFromVersionManager(path);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String loadResourceFromVersionManager(String file) {
        try (InputStream is2222 = this.camelCatalog.getVersionManager().getResourceAsStream(file);){
            if (is2222 != null) {
                String string = CatalogHelper.loadText((InputStream)is2222);
                return string;
            }
        }
        catch (IOException is2222) {
            // empty catch block
        }
        if (this.classLoader == null) return null;
        try (InputStream is = this.classLoader.getResourceAsStream(file);){
            if (is == null) return null;
            String string = CatalogHelper.loadText((InputStream)is);
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String sanitizeFileName(String fileName) {
        return fileName.replaceAll("[^A-Za-z0-9+-/]", "-");
    }
}

