/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consume;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.cdi.CdiBeanManagerHelper;
import org.apache.camel.cdi.CdiCamelContext;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.internal.BeanAdapter;
import org.apache.camel.cdi.internal.CamelContextBean;
import org.apache.camel.cdi.internal.CamelContextConfig;
import org.apache.camel.cdi.internal.CamelContextMap;
import org.apache.camel.cdi.internal.DelegateInjectionTarget;
import org.apache.camel.impl.DefaultCamelBeanPostProcessor;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;

public class CamelExtension
implements Extension {
    @Inject
    BeanManager beanManager;
    private CamelContextMap camelContextMap;
    private final Set<Bean<?>> eagerBeans = new HashSet();
    private final Map<String, CamelContextConfig> camelContextConfigMap = new HashMap<String, CamelContextConfig>();
    private final List<CamelContextBean> camelContextBeans = new ArrayList<CamelContextBean>();

    public static String getCamelContextName(String context, ContextName annotation) {
        if (ObjectHelper.isEmpty((Object)context) && annotation != null) {
            return annotation.value();
        }
        return context;
    }

    protected void contextAwareness(@Observes ProcessAnnotatedType<CamelContextAware> process) throws Exception {
        AnnotatedType at = process.getAnnotatedType();
        Method method = at.getJavaClass().getMethod("setCamelContext", CamelContext.class);
        AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(at).addToMethod(method, (Annotation)((Object)new InjectLiteral()));
        process.setAnnotatedType(builder.create());
    }

    protected void detectRouteBuilders(@Observes ProcessAnnotatedType<?> process) throws Exception {
        AnnotatedType annotatedType = process.getAnnotatedType();
        ContextName annotation = (ContextName)annotatedType.getAnnotation(ContextName.class);
        Class javaClass = annotatedType.getJavaClass();
        if (annotation != null && this.isRoutesBean(javaClass)) {
            this.addRouteBuilderBean(annotatedType, annotation);
        }
    }

    private void addRouteBuilderBean(AnnotatedType<?> process, ContextName annotation) {
        CamelContextConfig config = this.getCamelConfig(annotation.value());
        config.addRouteBuilderBean(process);
    }

    protected void disableDefaultContext(@Observes ProcessAnnotatedType<? extends CamelContext> process) {
        process.veto();
    }

    protected void registerManagedCamelContext(@Observes AfterBeanDiscovery abd, BeanManager manager) {
        if (this.camelContextConfigMap.isEmpty()) {
            abd.addBean((Bean)new CamelContextBean(manager));
        } else {
            Set<Map.Entry<String, CamelContextConfig>> entries = this.camelContextConfigMap.entrySet();
            for (Map.Entry<String, CamelContextConfig> entry : entries) {
                String name = entry.getKey();
                CamelContextConfig config = entry.getValue();
                CamelContextBean camelContextBean = new CamelContextBean(manager, "CamelContext:" + name, name, config);
                this.camelContextBeans.add(camelContextBean);
                abd.addBean((Bean)camelContextBean);
            }
        }
    }

    public void detectConsumeBeans(@Observes ProcessBean<?> event) {
        final Bean bean = event.getBean();
        Class beanClass = bean.getBeanClass();
        ReflectionHelper.doWithMethods((Class)beanClass, (ReflectionHelper.MethodCallback)new ReflectionHelper.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Consume consume = method.getAnnotation(Consume.class);
                if (consume != null) {
                    CamelExtension.this.eagerBeans.add(bean);
                }
            }
        });
    }

    public void detectRouteBuilderBeans(@Observes ProcessBean<?> event) {
        Bean bean = event.getBean();
        Class beanClass = bean.getBeanClass();
        if (this.isRoutesBean(beanClass)) {
            this.addRouteBuilderBean(bean, beanClass.getAnnotation(ContextName.class));
        }
    }

    private void addRouteBuilderBean(Bean<?> bean, ContextName annotation) {
        if (annotation != null) {
            String contextName = annotation.value();
            CamelContextConfig config = this.getCamelConfig(contextName);
            config.addRouteBuilderBean(bean);
        }
    }

    private CamelContextConfig getCamelConfig(String contextName) {
        CamelContextConfig config = this.camelContextConfigMap.get(contextName);
        if (config == null) {
            config = new CamelContextConfig();
            this.camelContextConfigMap.put(contextName, config);
        }
        return config;
    }

    public void detectProducerRoutes(@Observes ProcessProducerMethod<?, ?> event) {
        Annotated annotated = event.getAnnotated();
        ContextName annotation = (ContextName)annotated.getAnnotation(ContextName.class);
        Class<?> returnType = event.getAnnotatedProducerMethod().getJavaMember().getReturnType();
        if (this.isRoutesBean(returnType)) {
            this.addRouteBuilderBean(event.getBean(), annotation);
        }
    }

    public void startConsumeBeans(@Observes AfterDeploymentValidation event, BeanManager beanManager) throws Exception {
        for (CamelContextBean camelContextBean : this.camelContextBeans) {
            String name = camelContextBean.getCamelContextName();
            CamelContext context = this.getCamelContext(name, beanManager);
            if (context == null) {
                throw new IllegalStateException("CamelContext '" + name + "' has not been injected into the CamelContextMap");
            }
            camelContextBean.configureCamelContext((CdiCamelContext)context);
        }
        for (Bean bean : this.eagerBeans) {
            CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
            beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
        }
    }

    public void onInjectionTarget(@Observes ProcessInjectionTarget<?> event) {
        InjectionTarget injectionTarget = event.getInjectionTarget();
        AnnotatedType annotatedType = event.getAnnotatedType();
        Class beanClass = annotatedType.getJavaClass();
        final String beanName = injectionTarget.toString();
        ContextName contextName = (ContextName)annotatedType.getAnnotation(ContextName.class);
        final BeanAdapter adapter = this.createBeanAdapter(beanClass, contextName);
        if (!adapter.isEmpty()) {
            DelegateInjectionTarget newTarget = new DelegateInjectionTarget(injectionTarget){

                @Override
                public void inject(Object instance, CreationalContext ctx) {
                    super.inject(instance, ctx);
                    adapter.inject(CamelExtension.this, instance, beanName);
                }
            };
            event.setInjectionTarget((InjectionTarget)newTarget);
        }
    }

    public void inject(Object bean) {
        ContextName contextName;
        Class<?> beanClass = bean.getClass();
        BeanAdapter adapter = this.createBeanAdapter(beanClass, contextName = beanClass.getAnnotation(ContextName.class));
        if (!adapter.isEmpty()) {
            String beanName = bean.toString();
            adapter.inject(this, bean, beanName);
        }
    }

    private BeanAdapter createBeanAdapter(Class<?> beanClass, ContextName contextName) {
        final BeanAdapter adapter = new BeanAdapter(contextName);
        ReflectionHelper.doWithFields(beanClass, (ReflectionHelper.FieldCallback)new ReflectionHelper.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                EndpointInject endpointInject;
                Produce produce = field.getAnnotation(Produce.class);
                if (produce != null && !CamelExtension.injectAnnotatedField(field)) {
                    adapter.addProduceField(field);
                }
                if ((endpointInject = field.getAnnotation(EndpointInject.class)) != null) {
                    adapter.addEndpointField(field);
                }
            }
        });
        ReflectionHelper.doWithMethods(beanClass, (ReflectionHelper.MethodCallback)new ReflectionHelper.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                EndpointInject endpointInject;
                Produce produce;
                Consume consume = method.getAnnotation(Consume.class);
                if (consume != null) {
                    adapter.addConsumeMethod(method);
                }
                if ((produce = method.getAnnotation(Produce.class)) != null) {
                    adapter.addProduceMethod(method);
                }
                if ((endpointInject = method.getAnnotation(EndpointInject.class)) != null) {
                    adapter.addEndpointMethod(method);
                }
            }
        });
        return adapter;
    }

    protected DefaultCamelBeanPostProcessor getPostProcessor(String context, BeanManager beanManager) {
        CamelContext camelContext = this.getCamelContext(context, beanManager);
        if (camelContext != null) {
            return new DefaultCamelBeanPostProcessor(camelContext);
        }
        throw new IllegalArgumentException("No such CamelContext '" + context + "' available!");
    }

    protected CamelContext getCamelContext(String context, BeanManager beanManager) {
        BeanManager manager;
        BeanManager beanManager2 = manager = this.beanManager != null ? this.beanManager : beanManager;
        if (this.camelContextMap == null && manager != null) {
            this.camelContextMap = CdiBeanManagerHelper.lookupBeanByType(manager, CamelContextMap.class);
        }
        ObjectHelper.notNull((Object)this.camelContextMap, (String)"Could not resolve CamelContextMap");
        return this.camelContextMap.getCamelContext(context);
    }

    protected static boolean injectAnnotatedField(Field field) {
        return field.getAnnotation(Inject.class) != null;
    }

    protected boolean isRoutesBean(Class<?> returnType) {
        return (RoutesBuilder.class.isAssignableFrom(returnType) || RouteContainer.class.isAssignableFrom(returnType)) && !Modifier.isAbstract(returnType.getModifiers());
    }

    private static class InjectLiteral
    extends AnnotationLiteral<Inject> {
        private static final long serialVersionUID = 1L;

        private InjectLiteral() {
        }
    }
}

