/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.Vetoed;

@Vetoed
final class SyntheticAnnotated
implements Annotated {
    private final Class<?> type;
    private final Set<Type> types;
    private final Set<Annotation> annotations;

    SyntheticAnnotated(Class<?> type, Set<Type> types, Annotation ... annotations) {
        this(type, types, Arrays.asList(annotations));
    }

    SyntheticAnnotated(Class<?> type, Set<Type> types, Collection<Annotation> annotations) {
        this.type = type;
        this.types = types;
        this.annotations = new HashSet<Annotation>(annotations);
    }

    <A extends Annotation> void addAnnotation(A annotation) {
        this.annotations.add(annotation);
    }

    public Type getBaseType() {
        return this.type;
    }

    public Set<Type> getTypeClosure() {
        return Collections.unmodifiableSet(this.types);
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return (T)((Annotation)this.annotations.stream().filter(CdiSpiHelper.isAnnotationType(type)).findAny().map(type::cast).orElse(null));
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> type) {
        return this.annotations.stream().filter(CdiSpiHelper.isAnnotationType(type)).findAny().isPresent();
    }
}

