/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Producer;
import org.apache.camel.CamelContext;
import org.apache.camel.cdi.DelegateProducer;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiCamelContextPublisher;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;

final class CamelContextOsgiProducer<T extends CamelContext>
extends DelegateProducer<T> {
    CamelContextOsgiProducer(Producer<T> delegate) {
        super(delegate);
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        CamelContext context = (CamelContext)super.produce(ctx);
        BundleContext bundle = BundleContextUtils.getBundleContext(this.getClass());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new OsgiCamelContextPublisher(bundle));
        if (!(context instanceof DefaultCamelContext)) {
            throw new InjectionException("Camel CDI requires Camel context [" + context.getName() + "] to be a subtype of DefaultCamelContext");
        }
        DefaultCamelContext adapted = (DefaultCamelContext)context.adapt(DefaultCamelContext.class);
        adapted.setRegistry(OsgiCamelContextHelper.wrapRegistry((CamelContext)context, (Registry)context.getRegistry(), (BundleContext)bundle));
        CamelContextNameStrategy strategy = context.getNameStrategy();
        OsgiCamelContextHelper.osgiUpdate((DefaultCamelContext)adapted, (BundleContext)bundle);
        if (!(strategy instanceof DefaultCamelContextNameStrategy)) {
            context.setNameStrategy(strategy);
        }
        return (T)context;
    }
}

