/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.spi.Injector;

final class CdiCamelInjector
implements Injector {
    private final Injector injector;
    private final BeanManager manager;

    CdiCamelInjector(Injector injector, BeanManager manager) {
        this.injector = injector;
        this.manager = manager;
    }

    public <T> T newInstance(Class<T> type) {
        return this.newInstance(type, true);
    }

    public <T> T newInstance(Class<T> type, String factoryMethod) {
        T answer = null;
        try {
            Method fm = type.getMethod(factoryMethod, new Class[0]);
            if (Modifier.isStatic(fm.getModifiers()) && Modifier.isPublic(fm.getModifiers()) && fm.getReturnType() == type) {
                Object obj = fm.invoke(null, new Object[0]);
                answer = type.cast(obj);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error invoking factory method: " + factoryMethod + " on class: " + type, (Throwable)e);
        }
        return answer;
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        return (T)BeanManagerHelper.getReferenceByType(this.manager, type, new Annotation[0]).orElseGet(() -> this.injector.newInstance(type, postProcessBean));
    }

    public boolean supportsAutoWiring() {
        return false;
    }
}

