/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
final class CdiCamelBeanRepository
implements BeanRepository {
    private final Logger logger = LoggerFactory.getLogger(CdiCamelBeanRepository.class);
    private final BeanManager manager;

    CdiCamelBeanRepository(BeanManager manager) {
        this.manager = manager;
    }

    public Object lookupByName(String name) {
        StringHelper.notEmpty((String)name, (String)"name");
        this.logger.trace("Looking up bean with name [{}]", (Object)name);
        if ("properties".equals(name) && this.findByTypeWithName(PropertiesComponent.class).containsKey("properties")) {
            return BeanManagerHelper.getReferenceByName(this.manager, name, PropertiesComponent.class).orElse(null);
        }
        return BeanManagerHelper.getReferenceByName(this.manager, name, Object.class).orElse(null);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        StringHelper.notEmpty((String)name, (String)"name");
        ObjectHelper.notNull(type, (String)"type");
        this.logger.trace("Looking up bean with name [{}] of type [{}]", (Object)name, type);
        return BeanManagerHelper.getReferenceByName(this.manager, name, type).orElse(null);
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        this.logger.trace("Looking up named beans of type [{}]", type);
        return this.manager.getBeans(type, new Annotation[]{Any.Literal.INSTANCE}).stream().filter(bean -> bean.getName() != null).collect(Collectors.toMap(BeanAttributes::getName, bean -> BeanManagerHelper.getReference(this.manager, type, bean)));
    }

    public <T> Set<T> findByType(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        this.logger.trace("Looking up beans of type [{}]", type);
        return BeanManagerHelper.getReferencesByType(this.manager, type, new Annotation[]{Any.Literal.INSTANCE});
    }
}

