/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import javax.enterprise.inject.Vetoed;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.cdi.CdiEventEndpoint;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
final class CdiEventConsumer<T>
extends DefaultConsumer {
    private final Logger logger = LoggerFactory.getLogger(CdiEventConsumer.class);
    private final CdiEventEndpoint<T> endpoint;

    CdiEventConsumer(CdiEventEndpoint<T> endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.addConsumer(this);
    }

    protected void doStop() throws Exception {
        this.endpoint.removeConsumer(this);
        super.doStop();
    }

    void notify(T event) {
        this.logger.debug("Consuming CDI event [{}] with {}", event, (Object)this);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(event);
        if (event instanceof CamelEvent.ExchangeEvent) {
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setNotifyEvent(true);
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception cause) {
            throw new RuntimeExchangeException("Error while processing CDI event", exchange, (Throwable)cause);
        }
        finally {
            if (event instanceof CamelEvent.ExchangeEvent) {
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setNotifyEvent(false);
            }
        }
    }
}

