/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ec2.AWS2EC2Component;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.aws2.ec2.AWS2EC2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.ec2.Ec2Client;

public interface Aws2Ec2ComponentBuilderFactory {
    public static Aws2Ec2ComponentBuilder aws2Ec2() {
        return new Aws2Ec2ComponentBuilderImpl();
    }

    public static class Aws2Ec2ComponentBuilderImpl
    extends AbstractComponentBuilder<AWS2EC2Component>
    implements Aws2Ec2ComponentBuilder {
        @Override
        protected AWS2EC2Component buildConcreteComponent() {
            return new AWS2EC2Component();
        }

        private AWS2EC2Configuration getOrCreateConfiguration(AWS2EC2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AWS2EC2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "amazonEc2Client": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setAmazonEc2Client((Ec2Client)value);
                    return true;
                }
                case "configuration": {
                    ((AWS2EC2Component)component).setConfiguration((AWS2EC2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((AWS2EC2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setOperation((AWS2EC2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((AWS2EC2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "autowiredEnabled": {
                    ((AWS2EC2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2Ec2ComponentBuilder
    extends ComponentBuilder<AWS2EC2Component> {
        default public Aws2Ec2ComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2Ec2ComponentBuilder amazonEc2Client(Ec2Client amazonEc2Client) {
            this.doSetProperty("amazonEc2Client", amazonEc2Client);
            return this;
        }

        default public Aws2Ec2ComponentBuilder configuration(AWS2EC2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2Ec2ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2Ec2ComponentBuilder operation(AWS2EC2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2Ec2ComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2Ec2ComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2Ec2ComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2Ec2ComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2Ec2ComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2Ec2ComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2Ec2ComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2Ec2ComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2Ec2ComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2Ec2ComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2Ec2ComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

