/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.connector.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class FileHelper {
    private FileHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(isr);
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            isr.close();
            in.close();
        }
    }

    public static List<String> loadFile(File file) throws Exception {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        do {
            if ((line = reader.readLine()) == null) continue;
            lines.add(line);
        } while (line != null);
        reader.close();
        return lines;
    }

    public static List<String> loadFile(InputStream fis) throws Exception {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(fis));
        do {
            if ((line = reader.readLine()) == null) continue;
            lines.add(line);
        } while (line != null);
        reader.close();
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        try {
            in = new FileInputStream(from).getChannel();
            out = new FileOutputStream(to).getChannel();
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, 4096L, out)) {
            }
        }
        catch (Throwable throwable) {
            FileHelper.close(in);
            FileHelper.close(out);
            throw throwable;
        }
        FileHelper.close(in);
        FileHelper.close(out);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

