/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.controlbus.ControlBusComponent;
import org.apache.camel.component.controlbus.ControlBusProducer;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.11.0", scheme="controlbus", title="Control Bus", syntax="controlbus:command:language", producerOnly=true, category={Category.CORE, Category.MONITORING})
public class ControlBusEndpoint
extends DefaultEndpoint {
    @UriPath(description="Command can be either route or language", enums="route,language")
    @Metadata(required=true)
    private String command;
    @UriPath(enums="bean,constant,csimple,datasonnet,exchangeProperty,file,groovy,header,hl7terser,java,joor,jq,jsonpath,mvel,ognl,python,ref,simple,spel,tokenize,xpath,xquery,xtokenize")
    private Language language;
    @UriParam
    private String routeId;
    @UriParam(enums="start,stop,fail,suspend,resume,restart,status,stats")
    private String action;
    @UriParam(defaultValue="1000")
    private int restartDelay = 1000;
    @UriParam
    private boolean async;
    @UriParam(defaultValue="INFO")
    private LoggingLevel loggingLevel = LoggingLevel.INFO;
    private transient CamelLogger logger;

    public ControlBusEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    protected void doInit() throws Exception {
        this.logger = new CamelLogger(ControlBusProducer.class.getName(), this.loggingLevel);
    }

    public Producer createProducer() throws Exception {
        return new ControlBusProducer((Endpoint)this, this.logger);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume from a ControlBusEndpoint: " + this.getEndpointUri());
    }

    public ControlBusComponent getComponent() {
        return (ControlBusComponent)super.getComponent();
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public int getRestartDelay() {
        return this.restartDelay;
    }

    public void setRestartDelay(int restartDelay) {
        this.restartDelay = restartDelay;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }
}

