/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.csv.CsvIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.apache.commons.csv.writer.CSVConfig;
import org.apache.commons.csv.writer.CSVField;
import org.apache.commons.csv.writer.CSVWriter;

public class CsvDataFormat
implements DataFormat {
    private CSVStrategy strategy = CSVStrategy.DEFAULT_STRATEGY;
    private CSVConfig config = new CSVConfig();
    private boolean autogenColumns = true;
    private String delimiter;
    private boolean skipFirstLine;
    private boolean lazyLoad;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object object, OutputStream outputStream) throws Exception {
        if (this.delimiter != null) {
            this.config.setDelimiter(this.delimiter.charAt(0));
        }
        OutputStreamWriter out = new OutputStreamWriter(outputStream, IOHelper.getCharsetName((Exchange)exchange));
        CSVWriter csv = new CSVWriter(this.config);
        csv.setWriter((Writer)out);
        try {
            List list = (List)ExchangeHelper.convertToType((Exchange)exchange, List.class, (Object)object);
            if (list != null) {
                for (Object child : list) {
                    Map row = (Map)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Map.class, child);
                    this.doMarshalRecord(exchange, row, out, csv);
                }
            } else {
                Map row = (Map)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Map.class, (Object)object);
                this.doMarshalRecord(exchange, row, out, csv);
            }
        }
        finally {
            IOHelper.close((Closeable)out);
        }
    }

    private void doMarshalRecord(Exchange exchange, Map<?, ?> row, Writer out, CSVWriter csv) throws Exception {
        if (this.autogenColumns) {
            Set<?> set = row.keySet();
            this.updateFieldsInConfig(set, exchange);
        }
        csv.writeRecord(row);
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        CsvIterator csvIterator;
        block7: {
            if (this.delimiter != null) {
                this.config.setDelimiter(this.delimiter.charAt(0));
            }
            this.strategy.setDelimiter(this.config.getDelimiter());
            BufferedReader reader = null;
            boolean error = false;
            try {
                reader = IOHelper.buffered((Reader)new InputStreamReader(inputStream, IOHelper.getCharsetName((Exchange)exchange)));
                CSVParser parser = new CSVParser((Reader)reader, this.strategy);
                if (this.skipFirstLine) {
                    parser.getLine();
                }
                CsvIterator csvIterator2 = new CsvIterator(parser, reader);
                CsvIterator csvIterator3 = csvIterator = this.lazyLoad ? csvIterator2 : this.loadAllAsList(csvIterator2);
                if (!error) break block7;
            }
            catch (Exception e) {
                try {
                    error = true;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (error) {
                        IOHelper.close(reader);
                    }
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)reader);
        }
        return csvIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<String>> loadAllAsList(CsvIterator iter) {
        try {
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            while (iter.hasNext()) {
                list.add((List<String>)iter.next());
            }
            ArrayList<List<String>> arrayList = list;
            return arrayList;
        }
        finally {
            IOHelper.close((Closeable)iter);
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter != null && delimiter.length() > 1) {
            throw new IllegalArgumentException("Delimiter must have a length of one!");
        }
        this.delimiter = delimiter;
    }

    public CSVConfig getConfig() {
        return this.config;
    }

    public void setConfig(CSVConfig config) {
        this.config = config;
    }

    public CSVStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(CSVStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean isAutogenColumns() {
        return this.autogenColumns;
    }

    public void setAutogenColumns(boolean autogenColumns) {
        this.autogenColumns = autogenColumns;
    }

    public boolean isSkipFirstLine() {
        return this.skipFirstLine;
    }

    public void setSkipFirstLine(boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    private synchronized void updateFieldsInConfig(Set<?> set, Exchange exchange) {
        for (Object value : set) {
            String text;
            if (value == null || this.config.getField(text = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value)) != null) continue;
            CSVField field = new CSVField(text);
            this.config.addField(field);
        }
    }
}

