/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.cxf.MessageHeaderFilter;
import org.apache.camel.component.cxf.SoapMessageHeaderFilter;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfHeaderFilterStrategy
extends DefaultHeaderFilterStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CxfHeaderFilterStrategy.class);
    private Map<String, MessageHeaderFilter> messageHeaderFiltersMap;
    private List<MessageHeaderFilter> messageHeaderFilters;
    private boolean relayHeaders = true;
    private boolean allowFilterNamespaceClash;
    private boolean relayAllMessageHeaders;

    public CxfHeaderFilterStrategy() {
        this.initialize();
    }

    protected void initialize() {
        this.getOutFilter().add("operationName".toLowerCase());
        this.getOutFilter().add("operationNamespace".toLowerCase());
        this.getOutFilter().add("RequestContext".toLowerCase());
        this.getOutFilter().add("ResponseContext".toLowerCase());
        this.getOutFilter().add(Message.PROTOCOL_HEADERS.toLowerCase());
        this.getInFilter().add(Message.PROTOCOL_HEADERS.toLowerCase());
        this.getOutFilter().add("cache-control");
        this.getOutFilter().add("connection");
        this.getOutFilter().add("date");
        this.getOutFilter().add("pragma");
        this.getOutFilter().add("trailer");
        this.getOutFilter().add("transfer-encoding");
        this.getOutFilter().add("upgrade");
        this.getOutFilter().add("via");
        this.getOutFilter().add("warning");
        this.getOutFilter().add("Content-Type".toLowerCase());
        this.getOutFilter().add("Content-Length".toLowerCase());
        this.getInFilter().add("content-length".toLowerCase());
        this.setLowerCase(true);
        this.messageHeaderFiltersMap = new HashMap<String, MessageHeaderFilter>();
        this.addToMessageHeaderFilterMap(new SoapMessageHeaderFilter());
        this.setOutFilterPattern("(Camel|org\\.apache\\.camel)[\\.|a-z|A-z|0-9]*");
    }

    protected boolean extendedFilter(HeaderFilterStrategy.Direction direction, String key, Object value, Exchange exchange) {
        block8: {
            if (!Header.HEADER_LIST.equals(key) || value == null) {
                return false;
            }
            if (!this.relayHeaders) {
                return true;
            }
            if (this.relayAllMessageHeaders) {
                return false;
            }
            MessageHeaderFilter messageHeaderfilter = this.getMessageHeaderFilter(exchange);
            if (messageHeaderfilter == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No CXF Binding namespace can be resolved.  Message headers are intact.");
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("messageHeaderfilter = " + messageHeaderfilter);
            }
            try {
                messageHeaderfilter.filter(direction, (List)value);
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("Failed to cast value to Header<List> due to " + t.toString(), t);
            }
        }
        return false;
    }

    private void addToMessageHeaderFilterMap(MessageHeaderFilter filter) {
        for (String ns : filter.getActivationNamespaces()) {
            if (this.messageHeaderFiltersMap.containsKey(ns) && this.messageHeaderFiltersMap.get(ns) != this.messageHeaderFiltersMap && !this.allowFilterNamespaceClash) {
                throw new IllegalArgumentException("More then one MessageHeaderRelay activates for the same namespace: " + ns);
            }
            this.messageHeaderFiltersMap.put(ns, filter);
        }
    }

    private MessageHeaderFilter getMessageHeaderFilter(Exchange exchange) {
        BindingInfo b;
        BindingOperationInfo boi = (BindingOperationInfo)exchange.getProperty(BindingOperationInfo.class.getName(), BindingOperationInfo.class);
        String ns = null;
        if (boi != null && (b = boi.getBinding()) != null) {
            ns = b.getBindingId();
        }
        MessageHeaderFilter answer = null;
        if (ns != null) {
            answer = this.messageHeaderFiltersMap.get(ns);
        }
        return answer;
    }

    public void setMessageHeaderFilters(List<MessageHeaderFilter> messageHeaderFilters) {
        this.messageHeaderFilters = messageHeaderFilters;
        this.messageHeaderFiltersMap.clear();
        for (MessageHeaderFilter filter : messageHeaderFilters) {
            this.addToMessageHeaderFilterMap(filter);
        }
    }

    public List<MessageHeaderFilter> getMessageHeaderFilters() {
        return this.messageHeaderFilters;
    }

    public boolean isAllowFilterNamespaceClash() {
        return this.allowFilterNamespaceClash;
    }

    public void setAllowFilterNamespaceClash(boolean allowFilterNamespaceClash) {
        this.allowFilterNamespaceClash = allowFilterNamespaceClash;
    }

    public Map<String, MessageHeaderFilter> getMessageHeaderFiltersMap() {
        return this.messageHeaderFiltersMap;
    }

    public void setRelayHeaders(boolean relayHeaders) {
        this.relayHeaders = relayHeaders;
    }

    public boolean isRelayHeaders() {
        return this.relayHeaders;
    }

    public boolean isRelayAllMessageHeaders() {
        return this.relayAllMessageHeaders;
    }

    public void setRelayAllMessageHeaders(boolean relayAllMessageHeaders) {
        this.relayAllMessageHeaders = relayAllMessageHeaders;
    }
}

