/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.Handler;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.DefaultSEI;
import org.apache.camel.component.cxf.WSDLServiceFactoryBean;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfBlueprintEndpoint
extends CxfEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CxfBlueprintEndpoint.class);
    protected Map<String, Object> properties;
    private List<Handler> handlers;
    private List<String> schemaLocations;
    private BlueprintContainer blueprintContainer;
    private BundleContext bundleContext;
    private BlueprintCamelContext blueprintCamelContext;

    public CxfBlueprintEndpoint(String address, BundleContext context) {
        super(address);
        this.bundleContext = context;
    }

    @Override
    public List<Handler> getHandlers() {
        return this.handlers;
    }

    @Override
    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public void destroy() {
        BusFactory.setDefaultBus(null);
        BusFactory.setThreadDefaultBus(null);
    }

    @Override
    public void setServiceClass(String n) throws ClassNotFoundException {
        this.setServiceClass(this.bundleContext.getBundle().loadClass(n));
    }

    @Override
    Client createClient() throws Exception {
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notNull(this.getServiceClass(), (String)"serviceClass");
        }
        if (this.getWsdlURL() == null && this.getServiceClass() == null) {
            this.setServiceClass(DefaultSEI.class.getName());
            this.setDefaultOperationNamespace("http://camel.apache.org/cxf/jaxws/dispatch");
            this.setDefaultOperationName("Invoke");
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setSkipPayloadMessagePartCheck(true);
            }
        }
        Class<?> cls = null;
        if (this.getServiceClass() != null) {
            cls = this.getServiceClass();
            ClientProxyFactoryBean factoryBean = this.createClientFactoryBean(cls);
            this.setupClientFactoryBean(factoryBean, cls);
            return ((ClientProxy)Proxy.getInvocationHandler(factoryBean.create())).getClient();
        }
        this.checkName(this.getPortName(), "endpoint/port name");
        this.checkName(this.getServiceName(), "service name");
        ClientFactoryBean factoryBean = this.createClientFactoryBean();
        this.setupClientFactoryBean(factoryBean);
        return factoryBean.create();
    }

    @Override
    protected void checkName(Object value, String name) {
        if (ObjectHelper.isEmpty((Object)value)) {
            LOG.warn("The " + name + " of " + this.getEndpointUri() + " is empty, cxf will try to load the first one in wsdl for you.");
        }
    }

    @Override
    ServerFactoryBean createServerFactoryBean() throws Exception {
        Class<?> cls = null;
        if (this.getDataFormat() == DataFormat.POJO || this.getServiceClass() != null) {
            ObjectHelper.notNull(this.getServiceClass(), (String)"serviceClass");
            cls = this.getServiceClass();
        }
        Object answer = null;
        if (cls == null) {
            this.checkName(this.getPortName(), " endpoint/port name");
            this.checkName(this.getServiceName(), " service name");
            answer = new ServerFactoryBean((ReflectionServiceFactoryBean)new WSDLServiceFactoryBean());
        } else {
            answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        return answer;
    }

    @Override
    public void setSchemaLocations(List<String> schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    @Override
    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BlueprintCamelContext getBlueprintCamelContext() {
        return this.blueprintCamelContext;
    }

    public void setBlueprintCamelContext(BlueprintCamelContext blueprintCamelContext) {
        this.blueprintCamelContext = blueprintCamelContext;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public CxfBlueprintEndpoint getBean() {
        return this;
    }
}

