/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.GenericFileBinding;
import org.apache.camel.component.file.GenericFileDefaultBinding;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFile<T>
implements WrappedFile<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFile.class);
    private final boolean probeContentType;
    private String copyFromAbsoluteFilePath;
    private String endpointPath;
    private String fileName;
    private String fileNameOnly;
    private String relativeFilePath;
    private String absoluteFilePath;
    private long fileLength;
    private long lastModified;
    private T file;
    private GenericFileBinding<T> binding;
    private boolean absolute;
    private boolean directory;
    private String charset;
    private Map<String, Object> extendedAttributes;

    public GenericFile() {
        this(false);
    }

    public GenericFile(boolean probeContentType) {
        this.probeContentType = probeContentType;
    }

    public char getFileSeparator() {
        return File.separatorChar;
    }

    @Deprecated
    public void copyFrom(GenericFile source, GenericFile result) {
        result.setCopyFromAbsoluteFilePath(source.getAbsoluteFilePath());
        result.setEndpointPath(source.getEndpointPath());
        result.setAbsolute(source.isAbsolute());
        result.setDirectory(source.isDirectory());
        result.setAbsoluteFilePath(source.getAbsoluteFilePath());
        result.setRelativeFilePath(source.getRelativeFilePath());
        result.setFileName(source.getFileName());
        result.setFileNameOnly(source.getFileNameOnly());
        result.setFileLength(source.getFileLength());
        result.setLastModified(source.getLastModified());
        result.setFile(source.getFile());
        result.setBody(source.getBody());
        result.setBinding(source.getBinding());
        result.setCharset(source.getCharset());
        this.copyFromPopulateAdditional(source, result);
    }

    public void copyFromPopulateAdditional(GenericFile<T> source, GenericFile<T> result) {
    }

    public void bindToExchange(Exchange exchange) {
        GenericFileMessage<T> msg = this.commonBindToExchange(exchange);
        this.populateHeaders(msg, false);
    }

    public void bindToExchange(Exchange exchange, boolean isProbeContentTypeFromEndpoint) {
        GenericFileMessage<T> msg = this.commonBindToExchange(exchange);
        this.populateHeaders(msg, isProbeContentTypeFromEndpoint);
    }

    private GenericFileMessage<T> commonBindToExchange(Exchange exchange) {
        Map headers;
        exchange.setProperty("CamelFileExchangeFile", (Object)this);
        GenericFileMessage msg = new GenericFileMessage(exchange, this);
        if (exchange.hasOut()) {
            headers = exchange.getOut().hasHeaders() ? exchange.getOut().getHeaders() : null;
            exchange.setOut(msg);
        } else {
            headers = exchange.getIn().hasHeaders() ? exchange.getIn().getHeaders() : null;
            exchange.setIn(msg);
        }
        if (headers != null) {
            msg.setHeaders(headers);
            msg.removeHeaders("CamelFile*");
        }
        return msg;
    }

    public void populateHeaders(GenericFileMessage<T> message, boolean isProbeContentTypeFromEndpoint) {
        if (message != null) {
            message.setHeader("CamelFileNameOnly", this.getFileNameOnly());
            message.setHeader("CamelFileName", this.getFileName());
            message.setHeader("CamelFileNameConsumed", this.getFileName());
            message.setHeader("CamelFileAbsolute", this.isAbsolute());
            message.setHeader("CamelFileAbsolutePath", this.getAbsoluteFilePath());
            if (this.extendedAttributes != null) {
                message.setHeader("CamelFileExtendedAttributes", this.extendedAttributes);
            }
            if ((isProbeContentTypeFromEndpoint || this.probeContentType) && this.file instanceof File) {
                File f = (File)this.file;
                Path path = f.toPath();
                try {
                    message.setHeader("CamelFileContentType", Files.probeContentType(path));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.isAbsolute()) {
                message.setHeader("CamelFilePath", this.getAbsoluteFilePath());
            } else {
                String path = this.normalizePathToProtocol(this.getEndpointPath() + File.separator + this.getRelativeFilePath());
                message.setHeader("CamelFilePath", path);
            }
            message.setHeader("CamelFileRelativePath", this.getRelativeFilePath());
            message.setHeader("CamelFileParent", this.getParent());
            if (this.getFileLength() >= 0L) {
                message.setHeader("CamelFileLength", this.getFileLength());
            }
            if (this.getLastModified() > 0L) {
                message.setHeader("CamelFileLastModified", this.getLastModified());
            }
        }
    }

    protected boolean isAbsolute(String name) {
        return FileUtil.isAbsolute((File)new File(name));
    }

    protected String normalizePath(String name) {
        return FileUtil.normalizePath((String)name);
    }

    public void changeFileName(String newName) {
        LOG.trace("Changing name to: {}", (Object)newName);
        String newFileName = FileUtil.normalizePath((String)newName);
        String newEndpointPath = FileUtil.normalizePath((String)(this.endpointPath.endsWith("" + File.separatorChar) ? this.endpointPath : this.endpointPath + File.separatorChar));
        LOG.trace("Normalized endpointPath: {}", (Object)newEndpointPath);
        LOG.trace("Normalized newFileName: {}", (Object)newFileName);
        File file = new File(newFileName);
        if (!this.absolute && ObjectHelper.isNotEmpty((Object)newEndpointPath) && newFileName.startsWith(newEndpointPath)) {
            newFileName = newEndpointPath.endsWith("" + File.separatorChar) ? StringHelper.after((String)newFileName, (String)newEndpointPath) : StringHelper.after((String)newFileName, (String)(newEndpointPath + File.separatorChar));
            file = new File(newFileName);
        }
        this.setFileNameOnly(file.getName());
        this.setFileName(file.getName());
        if (file.getParent() != null) {
            this.setRelativeFilePath(file.getParent() + this.getFileSeparator() + file.getName());
        } else {
            this.setRelativeFilePath(file.getName());
        }
        if (this.isAbsolute(newFileName)) {
            this.setAbsolute(true);
            this.setAbsoluteFilePath(newFileName);
        } else {
            this.setAbsolute(false);
            String path = ObjectHelper.isEmpty((Object)this.endpointPath) ? "" : this.endpointPath + this.getFileSeparator();
            this.setAbsoluteFilePath(path + this.getRelativeFilePath());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("FileNameOnly: {}", (Object)this.getFileNameOnly());
            LOG.trace("FileName: {}", (Object)this.getFileName());
            LOG.trace("Absolute: {}", (Object)this.isAbsolute());
            LOG.trace("Relative path: {}", (Object)this.getRelativeFilePath());
            LOG.trace("Absolute path: {}", (Object)this.getAbsoluteFilePath());
            LOG.trace("Name changed to: {}", (Object)this);
        }
    }

    public String getRelativeFilePath() {
        return this.relativeFilePath;
    }

    public void setRelativeFilePath(String relativeFilePath) {
        this.relativeFilePath = this.normalizePathToProtocol(relativeFilePath);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = this.normalizePathToProtocol(fileName);
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Map<String, Object> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(Map<String, Object> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    public T getFile() {
        return this.file;
    }

    public void setFile(T file) {
        this.file = file;
    }

    public Object getBody() {
        return this.getBinding().getBody(this);
    }

    public void setBody(Object os) {
        this.getBinding().setBody(this, os);
    }

    public String getParent() {
        String parent;
        if (this.isAbsolute()) {
            String name = this.getAbsoluteFilePath();
            File path = new File(name);
            parent = path.getParent();
        } else {
            String name = this.getRelativeFilePath();
            File path = name != null ? new File(this.endpointPath, name) : new File(this.endpointPath);
            parent = path.getParent();
        }
        return this.normalizePathToProtocol(parent);
    }

    public GenericFileBinding<T> getBinding() {
        if (this.binding == null) {
            this.binding = new GenericFileDefaultBinding();
        }
        return this.binding;
    }

    public void setBinding(GenericFileBinding<T> binding) {
        this.binding = binding;
    }

    public void setAbsoluteFilePath(String absoluteFilePath) {
        this.absoluteFilePath = this.normalizePathToProtocol(absoluteFilePath);
    }

    public String getAbsoluteFilePath() {
        return this.absoluteFilePath;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    public void setEndpointPath(String endpointPath) {
        this.endpointPath = this.normalizePathToProtocol(endpointPath);
    }

    public String getFileNameOnly() {
        return this.fileNameOnly;
    }

    public void setFileNameOnly(String fileNameOnly) {
        this.fileNameOnly = fileNameOnly;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public String getCopyFromAbsoluteFilePath() {
        return this.copyFromAbsoluteFilePath;
    }

    public void setCopyFromAbsoluteFilePath(String copyFromAbsoluteFilePath) {
        this.copyFromAbsoluteFilePath = copyFromAbsoluteFilePath;
    }

    protected String normalizePathToProtocol(String path) {
        if (ObjectHelper.isEmpty((Object)path)) {
            return path;
        }
        path = path.replace('/', this.getFileSeparator());
        path = path.replace('\\', this.getFileSeparator());
        return path;
    }

    public String toString() {
        return "GenericFile[" + (this.absolute ? this.absoluteFilePath : this.relativeFilePath) + "]";
    }
}

