/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.TextEdit;

public class JavaFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private static final String EXCLUSION_PATTERN = "org.apache.camel.formatter.java.exclusion_pattern";
    private CodeFormatter formatter;
    private Pattern exclusionPattern;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        this.formatter = ToolFactory.createCodeFormatter(options, (int)ToolFactory.M_FORMAT_EXISTING);
        String ep = options.get(EXCLUSION_PATTERN);
        if (ep != null) {
            this.exclusionPattern = Pattern.compile(ep, 8);
        }
    }

    @Override
    public String doFormat(String code, LineEnding ending) throws IOException, BadLocationException {
        TextEdit te;
        try {
            ArrayList<Region> regions = new ArrayList<Region>();
            int start = 0;
            if (this.exclusionPattern != null) {
                Matcher matcher = this.exclusionPattern.matcher(code);
                while (matcher.find()) {
                    int s = matcher.start();
                    int e = matcher.end();
                    regions.add(new Region(start, s - start));
                    start = e;
                }
            }
            regions.add(new Region(start, code.length() - start));
            te = this.formatter.format(4104, code, regions.toArray(new IRegion[0]), 0, ending.getChars());
            if (te == null) {
                this.log.debug((CharSequence)"Code cannot be formatted. Possible cause is unmatched source/target/compliance version.");
                return null;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.debug((CharSequence)("Code cannot be formatted for text -->" + code + "<--"), (Throwable)e);
            return null;
        }
        Document doc = new Document(code);
        te.apply((IDocument)doc);
        String formattedCode = doc.get();
        if (code.equals(formattedCode)) {
            return null;
        }
        return formattedCode;
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }
}

