/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.freemarker.FreemarkerEndpoint;
import org.apache.camel.component.freemarker.NoCacheStorage;
import org.apache.camel.impl.DefaultComponent;
import org.springframework.core.io.Resource;

public class FreemarkerComponent
extends DefaultComponent {
    private Configuration configuraiton;
    private Configuration noCacheConfiguration;

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        FreemarkerEndpoint endpoint = new FreemarkerEndpoint(uri, (Component)this, remaining);
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        Configuration config = cache ? this.getConfiguraiton() : this.getNoCacheConfiguration();
        endpoint.setConfiguration(config);
        return endpoint;
    }

    public synchronized Configuration getConfiguraiton() {
        if (this.configuraiton == null) {
            this.configuraiton = new Configuration();
            this.configuraiton.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Resource.class, "/"));
        }
        return (Configuration)this.configuraiton.clone();
    }

    public void setConfiguraiton(Configuration configuraiton) {
        this.configuraiton = configuraiton;
    }

    private synchronized Configuration getNoCacheConfiguration() {
        if (this.noCacheConfiguration == null) {
            this.noCacheConfiguration = (Configuration)this.getConfiguraiton().clone();
            this.noCacheConfiguration.setCacheStorage((CacheStorage)new NoCacheStorage());
        }
        return this.noCacheConfiguration;
    }
}

