/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class FreemarkerEndpoint
extends ResourceEndpoint {
    private String encoding;
    private Configuration configuration;

    public FreemarkerEndpoint() {
    }

    public FreemarkerEndpoint(String uri, Component component, String resourceUri) {
        super(uri, component, resourceUri);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "freemarker:" + this.getResourceUri();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public FreemarkerEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (FreemarkerEndpoint)this.getCamelContext().getEndpoint(newUri, FreemarkerEndpoint.class);
    }

    public void clearContentCache() {
        this.configuration.clearTemplateCache();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Template template;
        Object dataModel;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = (String)exchange.getIn().getHeader("CamelFreemarkerResourceUri", String.class);
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelFreemarkerResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelFreemarkerResourceUri", (Object)newResourceUri);
            FreemarkerEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        StringReader reader = null;
        String content = (String)exchange.getIn().getHeader("CamelFreemarkerTemplate", String.class);
        if (content != null) {
            reader = new StringReader(content);
            exchange.getIn().removeHeader("CamelFreemarkerTemplate");
        }
        if ((dataModel = exchange.getIn().getHeader("CamelFreemarkerDataModel", Object.class)) == null) {
            dataModel = ExchangeHelper.createVariableMap((Exchange)exchange);
        }
        if (reader != null) {
            this.log.debug("Freemarker is evaluating template read from header {} using context: {}", (Object)"CamelFreemarkerTemplate", dataModel);
            template = new Template("temp", (Reader)reader, new Configuration());
        } else {
            this.log.debug("Freemarker is evaluating {} using context: {}", (Object)path, dataModel);
            template = this.getEncoding() != null ? this.configuration.getTemplate(path, this.getEncoding()) : this.configuration.getTemplate(path);
        }
        StringWriter buffer = new StringWriter();
        template.process(dataModel, (Writer)buffer);
        buffer.flush();
        Message out = exchange.getOut();
        out.setBody((Object)buffer.toString());
        out.setHeaders(exchange.getIn().getHeaders());
        out.setAttachments(exchange.getIn().getAttachments());
    }
}

