/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import java.net.URL;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ResourceBasedComponent;
import org.apache.camel.component.freemarker.FreemarkerEndpoint;
import org.apache.camel.component.freemarker.NoCacheStorage;
import org.apache.camel.util.ObjectHelper;

public class FreemarkerComponent
extends ResourceBasedComponent {
    private Configuration configuration;
    private Configuration noCacheConfiguration;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache;
        FreemarkerEndpoint endpoint = new FreemarkerEndpoint(uri, (Component)this, remaining);
        String encoding = (String)this.getAndRemoveParameter(parameters, "encoding", String.class);
        if (ObjectHelper.isNotEmpty((Object)encoding)) {
            endpoint.setEncoding(encoding);
        }
        Configuration config = (cache = ((Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE)).booleanValue()) ? this.getConfiguration() : this.getNoCacheConfiguration();
        endpoint.setConfiguration(config);
        return endpoint;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
            this.configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

                protected URL getURL(String name) {
                    return FreemarkerComponent.this.getResourceLoader().getClassLoader().getResource(name);
                }
            });
        }
        return (Configuration)this.configuration.clone();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private synchronized Configuration getNoCacheConfiguration() {
        if (this.noCacheConfiguration == null) {
            this.noCacheConfiguration = (Configuration)this.getConfiguration().clone();
            this.noCacheConfiguration.setCacheStorage((CacheStorage)new NoCacheStorage());
        }
        return this.noCacheConfiguration;
    }
}

