/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.SftpConsumer;
import org.apache.camel.component.file.remote.SftpProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpEndpoint
extends RemoteFileEndpoint<RemoteFileExchange> {
    protected final transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public SftpEndpoint(String uri, RemoteFileComponent remoteFileComponent, RemoteFileConfiguration configuration) {
        super(uri, remoteFileComponent, configuration);
    }

    public SftpEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public SftpProducer createProducer() throws Exception {
        return new SftpProducer(this, this.createSession());
    }

    public SftpConsumer createConsumer(Processor processor) throws Exception {
        SftpConsumer consumer = new SftpConsumer(this, processor, this.createSession());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected Session createSession() throws JSchException {
        String knownHostsFile;
        JSch jsch = new JSch();
        String privateKeyFile = this.getConfiguration().getPrivateKeyFile();
        if (ObjectHelper.isNotNullAndNonEmpty((String)privateKeyFile)) {
            this.log.debug((Object)("Using private keyfile: " + privateKeyFile));
            String privateKeyFilePassphrase = this.getConfiguration().getPrivateKeyFilePassphrase();
            if (ObjectHelper.isNotNullAndNonEmpty((String)privateKeyFilePassphrase)) {
                jsch.addIdentity(privateKeyFile, privateKeyFilePassphrase);
            } else {
                jsch.addIdentity(privateKeyFile);
            }
        }
        if (ObjectHelper.isNotNullAndNonEmpty((String)(knownHostsFile = this.getConfiguration().getKnownHosts()))) {
            this.log.debug((Object)("Using knownHosts: " + knownHostsFile));
            jsch.setKnownHosts(knownHostsFile);
        }
        Session session = jsch.getSession(this.getConfiguration().getUsername(), this.getConfiguration().getHost(), this.getConfiguration().getPort());
        session.setUserInfo(new UserInfo(){

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return SftpEndpoint.this.getConfiguration().getPassword();
            }

            public boolean promptPassword(String string) {
                return true;
            }

            public boolean promptPassphrase(String string) {
                return true;
            }

            public boolean promptYesNo(String string) {
                SftpEndpoint.this.log.error((Object)string);
                return false;
            }

            public void showMessage(String string) {
            }
        });
        return session;
    }

    public ChannelSftp createChannelSftp(Session session) throws JSchException {
        ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
        return channel;
    }
}

