/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFilePollingConsumerPollStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileConsumer<T>
extends GenericFileConsumer<T> {
    protected boolean loggedIn;

    public RemoteFileConsumer(RemoteFileEndpoint<T> endpoint, Processor processor, RemoteFileOperations<T> operations) {
        super(endpoint, processor, operations);
        this.setPollStrategy((PollingConsumerPollStrategy)new RemoteFilePollingConsumerPollStrategy());
    }

    protected RemoteFileOperations getOperations() {
        return (RemoteFileOperations)this.operations;
    }

    protected boolean prePollCheck() throws Exception {
        this.connectIfNecessary();
        if (!this.loggedIn) {
            String message = "Could not connect/login to: " + this.remoteServer() + ". Will skip this poll.";
            this.log.warn((Object)message);
            return false;
        }
        return true;
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.disconnect();
    }

    protected void disconnect() {
        try {
            if (this.getOperations().isConnected()) {
                this.loggedIn = false;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Disconnecting from: " + this.remoteServer()));
                }
                this.getOperations().disconnect();
            }
        }
        catch (GenericFileOperationFailedException e) {
            this.log.warn((Object)e.getMessage());
        }
    }

    protected void connectIfNecessary() throws IOException {
        if (!this.loggedIn) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Not connected/logged in, connecting to: " + this.remoteServer()));
            }
            this.loggedIn = this.getOperations().connect((RemoteFileConfiguration)this.endpoint.getConfiguration());
            if (this.loggedIn) {
                this.log.info((Object)("Connected and logged in to: " + this.remoteServer()));
            }
        }
    }

    protected String remoteServer() {
        return ((RemoteFileEndpoint)this.endpoint).remoteServerInformation();
    }
}

