/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpConsumer
extends RemoteFileConsumer<ChannelSftp.LsEntry> {
    private String endpointPath;

    public SftpConsumer(RemoteFileEndpoint<ChannelSftp.LsEntry> endpoint, Processor processor, RemoteFileOperations<ChannelSftp.LsEntry> operations) {
        super(endpoint, processor, operations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    protected void pollDirectory(String fileName, List<GenericFile<ChannelSftp.LsEntry>> fileList) {
        if (fileName == null) {
            return;
        }
        fileName = FileUtil.stripTrailingSeparator((String)fileName);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling directory: " + fileName));
        }
        List files = this.operations.listFiles(fileName);
        for (ChannelSftp.LsEntry file : files) {
            RemoteFile<ChannelSftp.LsEntry> remote;
            if (file.getAttrs().isDir()) {
                remote = this.asRemoteFile(fileName, file);
                if (!this.endpoint.isRecursive() || !this.isValidFile(remote, true)) continue;
                String directory = fileName + "/" + file.getFilename();
                this.pollDirectory(directory, fileList);
                continue;
            }
            remote = this.asRemoteFile(fileName, file);
            if (!this.isValidFile(remote, false)) continue;
            if (this.isInProgress(remote)) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("Skipping as file is already in progress: " + remote.getFileName()));
                continue;
            }
            fileList.add(remote);
        }
    }

    private RemoteFile<ChannelSftp.LsEntry> asRemoteFile(String directory, ChannelSftp.LsEntry file) {
        RemoteFile<ChannelSftp.LsEntry> answer = new RemoteFile<ChannelSftp.LsEntry>();
        answer.setEndpointPath(this.endpointPath);
        answer.setFile(file);
        answer.setFileName(file.getFilename());
        answer.setFileNameOnly(file.getFilename());
        answer.setFileLength(file.getAttrs().getSize());
        answer.setLastModified((long)file.getAttrs().getMTime() * 1000L);
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        answer.setAbsolute(false);
        String absoluteFileName = (ObjectHelper.isNotEmpty((Object)directory) ? directory + "/" : "") + file.getFilename();
        answer.setAbsoluteFilePath(absoluteFileName);
        String relativePath = ObjectHelper.after((String)absoluteFileName, (String)this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator((String)relativePath);
        answer.setRelativeFilePath(relativePath);
        return answer;
    }
}

