/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.util.ObjectHelper;

public abstract class RemoteFileConfiguration
extends GenericFileConfiguration {
    private String protocol;
    private String username;
    private String host;
    private int port;
    private String password;
    private boolean binary;
    private boolean passiveMode;
    private int connectTimeout = 10000;
    private int timeout = 30000;
    private int soTimeout;
    private boolean throwExceptionOnConnectFailed;
    private String siteCommand;

    public RemoteFileConfiguration() {
    }

    public RemoteFileConfiguration(URI uri) {
        this.configure(uri);
    }

    public boolean needToNormalize() {
        return false;
    }

    public void configure(URI uri) {
        super.configure(uri);
        this.setProtocol(uri.getScheme());
        this.setDefaultPort();
        String username = uri.getUserInfo();
        String pw = null;
        if (username != null && username.contains(":")) {
            pw = ObjectHelper.after((String)username, (String)":");
            username = ObjectHelper.before((String)username, (String)":");
        }
        if (username != null) {
            this.setUsername(username);
        }
        if (pw != null) {
            this.setPassword(pw);
        }
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
    }

    public String remoteServerInformation() {
        return this.protocol + "://" + (this.username != null ? this.username : "anonymous") + "@" + this.host + ":" + this.getPort();
    }

    protected abstract void setDefaultPort();

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port > 0) {
            this.port = port;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public boolean isThrowExceptionOnConnectFailed() {
        return this.throwExceptionOnConnectFailed;
    }

    public void setThrowExceptionOnConnectFailed(boolean throwExceptionOnConnectFailed) {
        this.throwExceptionOnConnectFailed = throwExceptionOnConnectFailed;
    }

    public String getSiteCommand() {
        return this.siteCommand;
    }

    public void setSiteCommand(String siteCommand) {
        this.siteCommand = siteCommand;
    }
}

