/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hazelcast.HazelcastCommand;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.atomicnumber.HazelcastAtomicnumberEndpoint;
import org.apache.camel.component.hazelcast.instance.HazelcastInstanceEndpoint;
import org.apache.camel.component.hazelcast.list.HazelcastListEndpoint;
import org.apache.camel.component.hazelcast.map.HazelcastMapEndpoint;
import org.apache.camel.component.hazelcast.multimap.HazelcastMultimapEndpoint;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueEndpoint;
import org.apache.camel.component.hazelcast.replicatedmap.HazelcastReplicatedmapEndpoint;
import org.apache.camel.component.hazelcast.ringbuffer.HazelcastRingbufferEndpoint;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConfiguration;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.component.hazelcast.set.HazelcastSetEndpoint;
import org.apache.camel.component.hazelcast.topic.HazelcastTopicEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ObjectHelper;

public class HazelcastComponent
extends UriEndpointComponent {
    private final HazelcastComponentHelper helper = new HazelcastComponentHelper();
    private HazelcastInstance hazelcastInstance;
    private transient boolean createOwnInstance;

    public HazelcastComponent() {
        super(HazelcastDefaultEndpoint.class);
    }

    public HazelcastComponent(CamelContext context) {
        super(context, HazelcastDefaultEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HazelcastInstance hzInstance = this.getOrCreateHzInstance(parameters);
        int defaultOperation = -1;
        Object operation = this.getAndRemoveOrResolveReferenceParameter(parameters, "operation", Object.class);
        if (operation == null) {
            operation = this.getAndRemoveOrResolveReferenceParameter(parameters, "defaultOperation", Object.class);
        }
        if (operation != null) {
            defaultOperation = this.helper.extractOperationNumber(operation, -1);
        }
        HazelcastDefaultEndpoint endpoint = null;
        if (remaining.startsWith("map:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("map:".length()), (char)'/');
            endpoint = new HazelcastMapEndpoint(hzInstance, uri, remaining, this);
            endpoint.setCommand(HazelcastCommand.map);
        }
        if (remaining.startsWith("multimap:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("multimap:".length()), (char)'/');
            endpoint = new HazelcastMultimapEndpoint(hzInstance, uri, remaining, this);
            endpoint.setCommand(HazelcastCommand.multimap);
        }
        if (remaining.startsWith("atomicvalue:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("atomicvalue:".length()), (char)'/');
            endpoint = new HazelcastAtomicnumberEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.atomicvalue);
        }
        if (remaining.startsWith("instance:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("instance:".length()), (char)'/');
            endpoint = new HazelcastInstanceEndpoint(hzInstance, uri, this);
            endpoint.setCommand(HazelcastCommand.instance);
        }
        if (remaining.startsWith("queue:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
            endpoint = new HazelcastQueueEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.queue);
        }
        if (remaining.startsWith("topic:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("topic:".length()), (char)'/');
            endpoint = new HazelcastTopicEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.topic);
        }
        if (remaining.startsWith("seda:")) {
            HazelcastSedaConfiguration config = new HazelcastSedaConfiguration();
            this.setProperties(config, parameters);
            config.setQueueName(remaining.substring(remaining.indexOf(":") + 1, remaining.length()));
            endpoint = new HazelcastSedaEndpoint(hzInstance, uri, this, config);
            endpoint.setCommand(HazelcastCommand.seda);
        }
        if (remaining.startsWith("list:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("list:".length()), (char)'/');
            endpoint = new HazelcastListEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.list);
        }
        if (remaining.startsWith("replicatedmap:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("replicatedmap:".length()), (char)'/');
            endpoint = new HazelcastReplicatedmapEndpoint(hzInstance, uri, remaining, this);
            endpoint.setCommand(HazelcastCommand.replicatedmap);
        }
        if (remaining.startsWith("set:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("set:".length()), (char)'/');
            endpoint = new HazelcastSetEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.set);
        }
        if (remaining.startsWith("ringbuffer:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("ringbuffer:".length()), (char)'/');
            endpoint = new HazelcastRingbufferEndpoint(hzInstance, uri, (Component)this, remaining);
            endpoint.setCommand(HazelcastCommand.ringbuffer);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException(String.format("Your URI does not provide a correct 'type' prefix. It should be anything like 'hazelcast:[%s|%s|%s|%s|%s|%s|%s|%s|%s|%s]name' but is '%s'.", "map:", "multimap:", "atomicvalue:", "instance:", "queue:", "seda:", "list:", "replicatedmap:", "set:", "ringbuffer:", uri));
        }
        if (defaultOperation != -1) {
            endpoint.setDefaultOperation(defaultOperation);
        }
        return endpoint;
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        if (this.createOwnInstance && this.hazelcastInstance != null) {
            this.hazelcastInstance.getLifecycleService().shutdown();
        }
        super.doStop();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    private HazelcastInstance createOwnInstance() {
        Config config = new XmlConfigBuilder().build();
        config.getProperties().setProperty("hazelcast.version.check.enabled", "false");
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    private HazelcastInstance getOrCreateHzInstance(Map<String, Object> parameters) {
        HazelcastInstance hzInstance = (HazelcastInstance)this.resolveAndRemoveReferenceParameter(parameters, "hazelcastInstance", HazelcastInstance.class);
        if (hzInstance == null && parameters.get("hazelcastInstanceName") != null) {
            hzInstance = Hazelcast.getHazelcastInstanceByName((String)((String)parameters.get("hazelcastInstanceName")));
        }
        if (hzInstance == null) {
            if (this.hazelcastInstance == null) {
                this.createOwnInstance = true;
                this.hazelcastInstance = this.createOwnInstance();
            }
            hzInstance = this.hazelcastInstance;
        }
        return hzInstance;
    }
}

