/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.map.HazelcastMapEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class HazelcastMapProducer
extends DefaultProducer {
    private final IMap<String, Object> cache;
    private final HazelcastComponentHelper helper = new HazelcastComponentHelper();
    private HazelcastInstance hazelcastInstance;

    public HazelcastMapProducer(HazelcastInstance hazelcastInstance, HazelcastMapEndpoint endpoint, String cacheName) {
        super((Endpoint)endpoint);
        this.hazelcastInstance = hazelcastInstance;
        this.cache = hazelcastInstance.getMap(cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        String oid = null;
        int operation = -1;
        String query = null;
        if (headers.containsKey("CamelHazelcastObjectId")) {
            oid = (String)headers.get("CamelHazelcastObjectId");
        }
        if (headers.containsKey("CamelHazelcastOperationType")) {
            operation = headers.get("CamelHazelcastOperationType") instanceof String ? this.helper.lookupOperationNumber((String)headers.get("CamelHazelcastOperationType")) : ((Integer)headers.get("CamelHazelcastOperationType")).intValue();
        }
        if (headers.containsKey("CamelHazelcastQuery")) {
            query = (String)headers.get("CamelHazelcastQuery");
        }
        switch (operation) {
            case 1: {
                this.put(oid, exchange);
                break;
            }
            case 3: {
                this.get(oid, exchange);
                break;
            }
            case 2: {
                this.delete(oid);
                break;
            }
            case 4: {
                this.update(oid, exchange);
                break;
            }
            case 5: {
                this.query(query, exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the MAP cache.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void query(String query, Exchange exchange) {
        Collection result = this.cache.values((Predicate)new SqlPredicate(query));
        exchange.getOut().setBody((Object)result);
    }

    private void update(String oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.lock((Object)oid);
        this.cache.replace((Object)oid, body);
        this.cache.unlock((Object)oid);
    }

    private void delete(String oid) {
        this.cache.remove((Object)oid);
    }

    private void get(String oid, Exchange exchange) {
        exchange.getOut().setBody(this.cache.get((Object)oid));
    }

    private void put(String oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.put((Object)oid, body);
    }
}

