/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class BasicAuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final String username;
    private final String password;
    private final String domain;
    private final String host;

    public BasicAuthenticationHttpClientConfigurer(String user, String pwd, String domain, String host) {
        this.username = user;
        this.password = pwd;
        this.domain = domain;
        this.host = host;
    }

    public void configureHttpClient(HttpClient client) {
        Object defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.host, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
    }
}

