/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.CompositeHttpConfigurer;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.ProxyHttpClientConfigurer;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpComponent
extends HeaderFilterStrategyComponent {
    protected HttpClientConfigurer httpClientConfigurer;
    protected HttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
    protected HttpBinding httpBinding;

    public void connect(HttpConsumer consumer) throws Exception {
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
    }

    protected void configureParameters(Map<String, Object> parameters) {
        String ref = (String)this.getAndRemoveParameter(parameters, "httpBindingRef", String.class);
        if (ref != null) {
            this.httpBinding = (HttpBinding)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)ref, HttpBinding.class);
        }
        if ((ref = (String)this.getAndRemoveParameter(parameters, "httpClientConfigurerRef", String.class)) != null) {
            this.httpClientConfigurer = (HttpClientConfigurer)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)ref, HttpClientConfigurer.class);
        }
        String username = (String)this.getAndRemoveParameter(parameters, "username", String.class);
        String password = (String)this.getAndRemoveParameter(parameters, "password", String.class);
        String domain = (String)this.getAndRemoveParameter(parameters, "domain", String.class);
        String host = (String)this.getAndRemoveParameter(parameters, "host", String.class);
        if (username != null && password != null) {
            this.httpClientConfigurer = CompositeHttpConfigurer.combineConfigurers(this.httpClientConfigurer, new BasicAuthenticationHttpClientConfigurer(username, password, domain, host));
        }
        String proxyHost = (String)this.getAndRemoveParameter(parameters, "proxyHost", String.class);
        Integer proxyPort = (Integer)this.getAndRemoveParameter(parameters, "proxyPort", Integer.class);
        if (proxyHost != null && proxyPort != null) {
            String proxyUsername = (String)this.getAndRemoveParameter(parameters, "proxyUsername", String.class);
            String proxyPassword = (String)this.getAndRemoveParameter(parameters, "proxyPassword", String.class);
            String proxyDomain = (String)this.getAndRemoveParameter(parameters, "proxyDomain", String.class);
            String proxyNtHost = (String)this.getAndRemoveParameter(parameters, "proxyNtHost", String.class);
            this.httpClientConfigurer = proxyUsername != null && proxyPassword != null ? CompositeHttpConfigurer.combineConfigurers(this.httpClientConfigurer, new ProxyHttpClientConfigurer(proxyHost, proxyPort, proxyUsername, proxyPassword, proxyDomain, proxyNtHost)) : CompositeHttpConfigurer.combineConfigurers(this.httpClientConfigurer, new ProxyHttpClientConfigurer(proxyHost, proxyPort));
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HttpClientParams clientParams = new HttpClientParams();
        IntrospectionSupport.setProperties((Object)clientParams, parameters, (String)"httpClient.");
        this.validateParameters(uri, parameters, "httpClient.");
        this.configureParameters(parameters);
        Boolean throwExceptionOnFailure = (Boolean)this.getAndRemoveParameter(parameters, "throwExceptionOnFailure", Boolean.class);
        Boolean bridgeEndpoint = (Boolean)this.getAndRemoveParameter(parameters, "bridgeEndpoint", Boolean.class);
        Boolean matchOnUriPrefix = Boolean.parseBoolean((String)this.getAndRemoveParameter(parameters, "matchOnUriPrefix", String.class));
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uri), (Map)CastUtils.cast(parameters));
        uri = httpUri.toString();
        String part = httpUri.getSchemeSpecificPart();
        if (part != null && ((part = part.toLowerCase()).startsWith("//http//") || part.startsWith("//https//"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        HttpEndpoint endpoint = new HttpEndpoint(uri, this, httpUri, clientParams, this.httpConnectionManager, this.httpClientConfigurer);
        if (this.httpBinding != null) {
            endpoint.setBinding(this.httpBinding);
        }
        this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        if (throwExceptionOnFailure != null) {
            endpoint.setThrowExceptionOnFailure(throwExceptionOnFailure);
        }
        if (bridgeEndpoint != null) {
            endpoint.setBridgeEndpoint(bridgeEndpoint);
        }
        if (matchOnUriPrefix != null) {
            endpoint.setMatchOnUriPrefix(matchOnUriPrefix);
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public HttpBinding getHttpBinding() {
        return this.httpBinding;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }
}

