/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.component.http.helper.HttpHelper;
import org.apache.camel.impl.DefaultExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelServlet
extends HttpServlet {
    private static final long serialVersionUID = -7061982839117697829L;
    protected final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String servletName;
    private ConcurrentMap<String, HttpConsumer> consumers = new ConcurrentHashMap<String, HttpConsumer>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletName = config.getServletName();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.trace("Service: {}", (Object)request);
        HttpConsumer consumer = this.resolve(request);
        if (consumer == null) {
            this.log.debug("No consumer to service request {}", (Object)request);
            response.sendError(404);
            return;
        }
        if (consumer.isSuspended()) {
            this.log.debug("Consumer suspended, cannot service request {}", (Object)request);
            response.sendError(503);
            return;
        }
        if ("TRACE".equals(request.getMethod()) && !consumer.isTraceEnabled()) {
            response.sendError(405);
        }
        DefaultExchange exchange = new DefaultExchange((Endpoint)consumer.getEndpoint(), ExchangePattern.InOut);
        if (consumer.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
        }
        if (consumer.getEndpoint().isDisableStreamCache()) {
            exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
        }
        HttpHelper.setCharsetFromContentType(request.getContentType(), (Exchange)exchange);
        exchange.setIn((Message)new HttpMessage((Exchange)exchange, request, response));
        try {
            this.log.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
            consumer.getProcessor().process((Exchange)exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        try {
            this.log.trace("Writing response for exchangeId: {}", (Object)exchange.getExchangeId());
            consumer.getBinding().writeResponse((Exchange)exchange, response);
        }
        catch (IOException e) {
            this.log.error("Error processing request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Error processing request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected HttpConsumer resolve(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        HttpConsumer answer = (HttpConsumer)((Object)this.consumers.get(path));
        if (answer == null) {
            for (String key : this.consumers.keySet()) {
                if (!((HttpConsumer)((Object)this.consumers.get(key))).getEndpoint().isMatchOnUriPrefix() || !path.startsWith(key)) continue;
                answer = (HttpConsumer)((Object)this.consumers.get(key));
                break;
            }
        }
        return answer;
    }

    public void connect(HttpConsumer consumer) {
        this.log.debug("Connecting consumer: {}", (Object)consumer);
        this.consumers.put(consumer.getPath(), consumer);
    }

    public void disconnect(HttpConsumer consumer) {
        this.log.debug("Disconnecting consumer: {}", (Object)consumer);
        this.consumers.remove(consumer.getPath());
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }
}

